<?php

declare(strict_types=1);

namespace Drupal\Tests\batch_messenger\Functional\Ui;

use Drupal\batch_messenger\Messenger\Stamp\CollectionItem;
use Drupal\batch_messenger\Ui\EventListener\RouteSubscriber;
use Drupal\batch_messenger_test\TestMessage;
use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\sm\Traits\SmAsyncTrait;
use Symfony\Component\Messenger\Envelope;
use Symfony\Component\Messenger\MessageBusInterface;

final class BatchMessengerUiTest extends BrowserTestBase {

  use SmAsyncTrait;

  protected $defaultTheme = 'stark';

  protected static $modules = [
    'sm',
    'batch_messenger',
    'batch_messenger_test',
    // Needed for drupalPlaceBlock 🙄.
    'block',
  ];

  protected function setUp(): void {
    parent::setUp();

    // \Drupal\Core\Menu\Plugin\Block\LocalActionsBlock.
    // Could be simpler with https://www.drupal.org/project/drupal/issues/3524985.
    $this->drupalPlaceBlock('local_actions_block');
  }

  public function testUi(): void {
    /** @var \Drupal\user\UserInterface $user */
    $user = $this->createUser(['batch_messenger ui view all batches']);
    $this->drupalLogin($user);
    $this->drupalGet(Url::fromRoute(RouteSubscriber::COLLECTION_ROUTE_NAME));
    $this->assertSession()->pageTextContains('No message collections found.');

    /** @var non-empty-string $collectionName */
    $collectionName = $this->randomMachineName();
    static::bus()->dispatch(new Envelope(
      message: new TestMessage(),
      stamps: [
        CollectionItem::create($collectionName, '#id1'),
      ],
    ));

    $this->drupalGet(Url::fromRoute(RouteSubscriber::COLLECTION_ROUTE_NAME));
    $this->assertSession()->pageTextNotContains('No message collections found.');
    $this->assertSession()->elementTextContains('css', 'table tbody tr:nth-child(1) td:nth-child(1)', $collectionName);
    $this->assertSession()->elementTextContains('css', 'table tbody tr:nth-child(1) td:nth-child(3)', '0');
    $this->assertSession()->elementTextContains('css', 'table tbody tr:nth-child(1) td:nth-child(4)', '1');
    $this->assertSession()->elementTextContains('css', 'table tbody tr:nth-child(1) td:nth-child(5)', 'Complete');
    $this->assertSession()->elementsCount('css', 'table tbody tr', count: 1);

    $this->getSession()->getPage()->clickLink('Clear complete');
    $this->assertSession()->pageTextContains('Cleared completed collections.');
    $this->assertSession()->pageTextContains('No message collections found.');
  }

  private static function bus(): MessageBusInterface {
    /** @var \Symfony\Component\Messenger\MessageBusInterface */
    return \Drupal::service(MessageBusInterface::class);
  }

}
