<?php

declare(strict_types=1);

namespace Drupal\batch_plugin\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The batch_plugin.batch_plugin attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
final class BatchPlugin extends AttributeBase {

  /**
   * Constructor for initializing the object with the given parameters.
   *
   * @param string $id
   *   The plugin ID. There are some implementation bugs that make the plugin
   *   available only if the ID follows a specific pattern. It must be either
   *   identical to group or prefixed with the group. E.g. if the group is "foo"
   *   the ID must be either "foo" or "foo:bar".
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The title for the plugin, optional.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   A description for the plugin, optional.
   * @param string|null $processors
   *   An comma separated list of processors that can run the plugin.
   *
   *   If empty, any can be used.
   *
   *   The first one in the list will be the default if you process without
   *   first specifying a processor.
   * @param string|null $permission
   *   The required permission for the object, optional.
   *   NOT IMPLEMENTED YET!
   * @param string|null $cronexpression
   *   A cron expression defining scheduled execution, optional.
   *   A complex CRON expression, e.g \/5 * * * *
   *   Or macros. See https://github.com/dragonmantank/cron-expression
   *   '@yearly', '@annually' - Run once a year, midnight, Jan. 1 - 0 0 1 1 *
   *   '@monthly' - Run once a month, midnight, first of month - 0 0 1 * *
   *   '@weekly' - Run once a week, midnight on Sun - 0 0 * * 0
   *   '@daily', '@midnight' - Run once a day, midnight - 0 0 * * *
   *   '@hourly' - Run once an hour, first minute - 0 * * * *.
   * @param bool|null $hidden
   *   Whether to hide from batch_plugin_entity, defaults to FALSE.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly ?string $processors = 'batch_api,cron,queue',
    public readonly ?string $permission = NULL,
    public readonly ?string $cronexpression = NULL,
    public readonly ?bool $hidden = FALSE,
  ) {}

}
