<?php

namespace Drupal\batch_plugin\Drush;

use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Provides methods for processing batch plugins within Drush commands.
 */
trait DrushCommandsTrait {

  use StringTranslationTrait;

  /**
   * Processes a batch plugin and optionally executes it with processor plugin.
   *
   * @param string $plugin_id
   *   The ID of the batch plugin to process.
   * @param string $processor_plugin_id
   *   (optional) The ID of the processor plugin to override its default.
   *   Defaults to 'drush'.
   */
  public function processPlugin($plugin_id, $processor_plugin_id = 'drush') {
    if (!$this->pluginManager->hasDefinition($plugin_id)) {
      $this->output->writeln('<error>Batch plugin not found</error>');
      return;
    }
    if (!$this->processorPluginManager->hasDefinition($processor_plugin_id)) {
      $this->output->writeln('<error>Processor plugin not found</error>');
      return;
    }
    /** @var \Drupal\batch_plugin\BatchPluginInterface $plugin */
    $plugin = $this->pluginManager->createInstance($plugin_id);
    $plugin->process($processor_plugin_id);
    if (empty($plugin->getOperations())) {
      $this->output()->writeln($this->t('No operations to process.'));
    }
    else {
      drush_backend_batch_process();
    }
    $this->output()->writeln($this->t('Batch operations end.'));
  }
}
