<?php

namespace Drupal\batch_plugin\Commands;

use Drupal\batch_plugin\BatchPluginManager;
use Drupal\batch_plugin\Drush\DrushCommandsTrait;
use Drupal\batch_plugin\ProcessorPluginManager;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drush\Commands\DrushCommands;

/**
 * A Drush commandfile.
 */
class ProcessBatchPluginCommands extends DrushCommands {

  use StringTranslationTrait;
  use DrushCommandsTrait;

  /**
   * The batch plugin manager.
   *
   * @var \Drupal\batch_plugin\BatchPluginManager
   */
  protected $pluginManager;

  /**
   * The batch processor plugin manager.
   *
   * @var \Drupal\batch_plugin\ProcessorPluginManager
   */
  protected $processorPluginManager;

  /**
   * Constructs a new command.
   *
   * @param \Drupal\batch_plugin\BatchPluginManager $plugin_manager
   *   The batch plugin manager.
   * @param \Drupal\batch_plugin\ProcessorPluginManager $processor_plugin_manager
   *   The batch processor plugin manager.
   */
  public function __construct(BatchPluginManager $plugin_manager, ProcessorPluginManager $processor_plugin_manager) {
    parent::__construct();
    $this->pluginManager = $plugin_manager;
    $this->processorPluginManager = $processor_plugin_manager;
  }

  /**
   * Run a batch plugin.
   *
   * @param string $plugin_id
   *   The batch plugin ID.
   * @param string|null $processor_plugin_id
   *   Optional parameter to override the processor plugin ID.
   *
   * @command batch_plugin:process
   * @aliases bpp
   * @group
   *
   * @usage batch_plugin:process example_batch_plugin
   */
  public function processBatchPlugin(string $plugin_id, string $processor_plugin_id = 'drush') {
    $this->processPlugin($plugin_id, $processor_plugin_id);
  }

}
