<?php

namespace Drupal\batch_plugin\Drush\Commands;

use Consolidation\OutputFormatters\StructuredData\RowsOfFields;
use Drupal\batch_plugin\Drush\DrushCommandsTrait;
use Drupal\Core\Utility\Token;
use Drupal\batch_plugin\BatchPluginManager;
use Drupal\batch_plugin\ProcessorPluginManagerInterface;
use Drush\Attributes as CLI;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;

/**
 * A Drush commandfile.
 */
class ProcessBatchPluginCommands extends DrushCommands {

  use AutowireTrait;
  use DrushCommandsTrait;

  /**
   * Constructs a ProcessBatchPluginCommands object.
   */
  public function __construct(
    private readonly BatchPluginManager $pluginManager,
    private readonly ProcessorPluginManagerInterface $processorPluginManager,
  ) {
    parent::__construct();
  }

  /**
   * Processes a batch plugin and optionally executes it with a specific processor plugin.
   *
   * @param string $plugin_id
   *   The ID of the batch plugin to process.
   * @param string $processor_plugin_id
   *   (optional) The ID of the processor plugin to override its default. Defaults to 'drush'.
   *
   * @return void
   *   No return value.
   */
  #[CLI\Command(name: 'batch_plugin:process', aliases: ['bpp'])]
  #[CLI\Argument(name: 'plugin_id', description: 'The batch plugin ID.')]
  #[CLI\Argument(name: 'processor_plugin_id', description: 'Optional parameter to override the processor plugin ID.')]
  #[CLI\Usage(name: 'batch_plugin:process example_batch_plugin', description: 'Usage description')]
  public function processBatchPlugin($plugin_id, $processor_plugin_id = 'drush') {
    $this->processPlugin($plugin_id, $processor_plugin_id);
  }

}
