<?php

namespace Drupal\user_importer\Service;

use PhpOffice\PhpSpreadsheet\IOFactory;

final class ExcelReader {
  public function readRows(string $path, int $headerRow = 1): array {
    $spreadsheet = IOFactory::load($path);
    $sheet = $spreadsheet->getActiveSheet();
    $rows = [];
    $headers = [];

    foreach ($sheet->getRowIterator() as $row) {
      $r = $row->getRowIndex();
      $cells = [];
      foreach ($row->getCellIterator() as $cell) {
        $cells[] = trim((string) $cell->getFormattedValue());
      }
      if ($r === $headerRow) {
        $headers = array_map(fn($h) => strtolower(preg_replace('/\s+/', '_', $h)), $cells);
        continue;
      }
      if ($headers === []) continue;
      if (count(array_filter($cells, fn($v) => $v !== '')) === 0) continue;
      $rows[] = array_replace(array_fill_keys($headers, ''), array_combine($headers, $cells));
    }
    return $rows;
  }
}
