<?php

namespace Drupal\be_ixf_drupal\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class AdminForm.
 *
 * Provides a form for managing the configuration settings of the module.
 *
 * @package Drupal\be_ixf_drupal\Form
 */
class AdminForm extends ConfigFormBase {

/**
 * {@inheritdoc}
 *
 * Returns the unique identifier for the settings form.
 */
  public function getFormId() {
    return 'be_ixf_drupal_settings_form';
  }

/**
 * {@inheritdoc}
 *
 * Returns the names of the editable configuration objects.
 */
  protected function getEditableConfigNames() {
    return [BE_IXF_DRUPAL];
  }

  /**
   * {@inheritdoc}
   *
   * Builds the settings form for the be_ixf_drupal module.
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $config = $this->config(BE_IXF_DRUPAL);

    $form[CAPSULE_MODE] = [
      TYPE => 'select',
      TITLE => $this->t('Capsule Mode'),
      DESCRIPTION => $this->t('Mode to use for connecting to BrightEdge. Leave as default.'),
      '#options' => [
        'REMOTE_PROD_CAPSULE_MODE' => $this->t('Production'),
        'REMOTE_PROD_GLOBAL_CAPSULE_MODE' => $this->t('Production Global'),
      ],
      DEFAULT_VALUE => $config->get(CAPSULE_MODE),
    ];

    $form['account_id'] = [
      TYPE => TEXTFIELD,
      TITLE => $this->t('Account Id'),
      DESCRIPTION => $this->t('Account configured in the f000000ZZZ form'),
      '#size' => 20,
      '#maxlength' => 20,
      '#required' => TRUE,
      DEFAULT_VALUE => $config->get(ACCOUNT_ID) !== NULL ? $config->get(ACCOUNT_ID) : '',
    ];

    $form[ENABLE_STORAGE_CAPSULE] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable Storage Capsule'),
      '#description' => $this->t('Enable storage capsule'),
      '#default_value' => $config->get(ENABLE_STORAGE_CAPSULE) !== NULL ? $config->get(ENABLE_STORAGE_CAPSULE) : false,
    ];

    $form['api_endpoint'] = [
      TYPE => TEXTFIELD,
      TITLE => $this->t('API Endpoint (Optional)'),
      DESCRIPTION => $this->t('API Endpoint in https://ixfN-api.bc0a.com'),
      DEFAULT_VALUE => $config->get(API_ENDPOINT) !== NULL ? $config->get(API_ENDPOINT) : '',
    ];

    $form['block_cache_max_age'] = [
      TYPE => TEXTFIELD,
      TITLE => $this->t('Block Cache Maximum Age'),
      '#size' => 4,
      '#maxlength' => 6,
      DESCRIPTION => $this->t('The maximum age cache time for the block in seconds'),
      DEFAULT_VALUE => $config->get(BLOCK_CACHE_MAX_AGE) !== NULL ? $config->get(BLOCK_CACHE_MAX_AGE) : '3600',
    ];

    $form['canonical_host'] = [
      TYPE => TEXTFIELD,
      TITLE => $this->t('Canonical Host (Optional)'),
      DESCRIPTION => $this->t('canonical host'),
      '#required' => FALSE,
      DEFAULT_VALUE => $config->get(CANONICAL_HOST) !== NULL ? $config->get(CANONICAL_HOST) : '',
    ];

    $form['protocol'] = [
      '#type' => 'radios',
      '#title' => $this->t('Protocol'),
      '#default_value' => $config->get('protocol') ?: 'http',
      '#options' => [
        'http' => $this->t('HTTP'),
        'https' => $this->t('HTTPS'),
      ],
    ];

    return parent::buildForm($form, $form_state);
  }

/**
 * {@inheritdoc}
 *
 * Validates the settings form input.
 */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
    if (!is_numeric($values[BLOCK_CACHE_MAX_AGE])) {
      //form_set_error(BLOCK_CACHE_MAX_AGE, t('You must enter an integer for block cache maximum age.'));
        $form_state->setErrorByName(BLOCK_CACHE_MAX_AGE, t('You must enter an integer for block cache maximum age.'));

    }
    parent::validateForm($form, $form_state);

  }

  /**
   * {@inheritdoc}
   *
   * Submits the settings form and saves the configuration.
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
    $account_id = trim($values[ACCOUNT_ID]);
    $api_endpoint = trim($values[API_ENDPOINT]);

    $this->configFactory()->getEditable(BE_IXF_DRUPAL)
      ->set(CAPSULE_MODE, $values[CAPSULE_MODE])
      ->set(ACCOUNT_ID, $account_id)
      ->set(ENABLE_STORAGE_CAPSULE, $values[ENABLE_STORAGE_CAPSULE])
      ->set(API_ENDPOINT, $api_endpoint)
      ->set(BLOCK_CACHE_MAX_AGE, $values[BLOCK_CACHE_MAX_AGE])
      ->set(CANONICAL_HOST, $values[CANONICAL_HOST])
      ->set(PROTOCOL, $values[PROTOCOL])
      ->save();

    parent::submitForm($form, $form_state);
  }

}
