<?php

namespace Drupal\bee_hotel;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Provides route responses for BeeHotel module.
 */
class BeeHotelGuestMessageHooks {

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a new CurrencyApiService.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * Use token hook or fallback.
   *
   * Every yml token should have a method here to elaborate the value.
   * This method search for the token method, falling back when
   * token method is missing.
   *
   * @param string $id
   *   The token id.
   * @param array $token
   *   The token.
   * @param array $d
   *   The data.
   *
   * @return string
   *   A string value for the token.
   */
  public function main($id, array $token, array $d) {

    if (method_exists($this, $id)) {
      return $this->$id($token, $d);
    }
    else {
      return "Missing method for " . $id;
    }

  }

  /**
   * Hook method.
   */
  private function balance_cash_euro($token, $d) {
    $tmp = $token['#value']['settings']['property'];
    $d['tokens'][$token['#value']['id']]['value'] = $d['commerce_order']->get($token['#value']['settings']['field'])->$tmp;
    $d['tokens'][$token['#value']['id']]['value'] = floor($d['tokens'][$token['#value']['id']]['value'] * 0.1) / 0.1;
    return $d['tokens'][$token['#value']['id']]['value'];
  }

  /**
   * Hook method.
   */
  private function balance_cash_currencies($token, &$d) {

    $d['config'] = $this->configFactory;
    $balance = $d['commerce_order']->get('balance')->number;
    $currencyApi = \Drupal::service('currencyapi.service');
    $rates = $currencyApi->getAllRates();

    $output = "<ul>";
    $output = "";
    foreach ($rates as $code => $value) {
      if ($value['is_default'] != TRUE) {
        $tmp = $currencyApi->convert($balance, 'EUR', $value['code']);
        $output .= ". " . $value['code'] . ": " . $tmp . "<br/>";
      }
    }
    return $output;
  }

  /**
   * Hook method.
   */
  private function guest_name($token, $d) {
    $d['billing_profile']['id'] = $d['commerce_order']->get("billing_profile")->target_id;
    $d['billing_profile']['entity'] = $d['commerce_order']->get("billing_profile")->entity;
    $d['billing_profile']['address'] = $d['billing_profile']['entity']->address->getValue();
    $d['billing_profile']['given_name'] = $d['billing_profile']['entity']->address->getValue()[0]['given_name'];
    if (isset($d['billing_profile']['given_name'])) {
      return $d['billing_profile']['given_name'];
    }
    else {
      return $d['commerce_order']->get('mail')->value;
    }
  }

  /**
   * Hook method.
   */
  private function room_name($token, &$d) {
    $d['config'] = $this->configFactory;
    /** @var \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager */
    $entity_type_manager = \Drupal::entityTypeManager();
    $d['order_item'] = $entity_type_manager->getStorage('commerce_order_item')
      ->load($d['commerce_order']->get('order_items')->target_id);
    $d['room_name'] = $d['order_item']->get("title")->value;
    return $d['room_name'];
  }

}
