<?php

namespace Drupal\bee_hotel\Form;

use Drupal\beehotel_utils\BeeHotelCommerce;
use Drupal\Core\Config\ConfigFactory;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\symfony_mailer\EmailFactoryInterface;
use Drupal\symfony_mailer\MailerHelperInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Send Guest Messages.
 */
class BeeHotelGuestMessagesMail extends FormBase {

  /**
   * Config settings.
   *
   * @var string
   */
  const SETTINGS = 'beehotel.settings';

  /**
   * Drupal configuration service container.
   *
   * @var \Drupal\Core\Config\ConfigFactory
   */
  protected $configFactory;

  /**
   * The BeeHotel commerce Util.
   *
   * @var \Drupal\beehotel_utils\BeeHotelCommerce
   */
  protected $beehotelCommerce;


  /**
   * The email factory service.
   *
   * @var \Drupal\symfony_mailer\EmailFactoryInterface
   */
  protected $emailFactory;

  /**
   * The mailer helper.
   *
   * @var \Drupal\symfony_mailer\MailerHelperInterface
   */
  protected $helper;

  /**
   * {@inheritdoc}
   *
   * @param \Drupal\Core\Config\ConfigFactory $config_factory
   *   The config factory.
   * @param \Drupal\beehotel_utils\BeeHotelCommerce $beehotel_commerce
   *   BeeHotel Commerce Utils.
   * @param \Drupal\symfony_mailer\EmailFactoryInterface $email_factory
   *   The email factory service.
   * @param \Drupal\symfony_mailer\MailerHelperInterface $helper
   *   The mailer helper.
   */
  public function __construct(ConfigFactory $config_factory, BeeHotelCommerce $beehotel_commerce, EmailFactoryInterface $email_factory, MailerHelperInterface $helper) {
    $this->configFactory = $config_factory;
    $this->beehotelCommerce = $beehotel_commerce;
    $this->emailFactory = $email_factory;
    $this->helper = $helper;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('beehotel_utils.beehotelcommerce'),
      $container->get('email_factory'),
      $container->get('symfony_mailer.helper'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'beehotel_guestmessages';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      static::SETTINGS,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $node = NULL, $commerce_order = NULL) {

    $d = [];

    $d['config'] = $this->config('beehotel.settings');
    $d['path'] = \Drupal::service('extension.list.module')->getPath('bee_hotel');
    $d['node'] = $node;
    $d['commerce_order'] = $commerce_order;

    $form['to'] = [
      '#default_value' => $d['commerce_order']->get('mail')->value,
      '#type' => 'textfield',
      '#title' => $this->t('to:'),
      '#description' => $this->t('Thr mail address to which send the message.'),
    ];

    $form['message'] = [
      '#type' => 'html_tag',
      '#tag' => 'div',
      '#value' => $d['node']->get('field_message')->value,
      '#title' => $this->t('Set up Vertical'),
    ];

    $form['confirm'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Confirm send'),
      '#description' => $this->t('With this check you can confim the send'),
    ];

    $form['actions']['#type'] = 'actions';
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Send now'),
      '#button_type' => 'primary',
    ];

    $form['#suffix'] = "</div>";
    $form['#attached']['library'][] = 'bee_hotel/beehotel-litepicker';

    return $form;

  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();

    // $qid = substr($values['form_build_id'], 5, 18);
    // $this->session->set('beehotel_units_search_queries', [
    // $qid => $values,
    // ]);
    // Send the mailer
    // Long into order log
    $form_state->setRedirect('beehotel.search_result', ['qid' => $qid]);
  }

  /**
   * Update modules weight.
   */
  public function submitUpdateweight(array &$form, FormStateInterface $form_state) {
    bee_hotel_update_modules_weight();
    $this->messenger()->addStatus($this->t('Modules weight updated'));
  }

}
