## CONTENTS OF THIS FILE

- Introduction
- Installation
- Creating a Theme from Starterkit
- Creating a Subtheme
- Configuration
- Build Tools
- Maintainers

## INTRODUCTION

Belgrade is a Bootstrap based theme made for Drupal Commerce 2.x.

The Belgrade Drupal Theme is a highly versatile and customizable Drupal theme that is built around
Commerce Kickstart and Layout Builder. It incorporates fully customized Bootstrap 5 and Bootstrap
Icons, providing a wide range of theming best practice examples. With the Belgrade theme, you have
extensive configuration options to adjust layouts, change fonts, handle status messages, manage
icons, add classes, and utilize predefined product teaser designs. The theme uses modern frontend
tools including PostCSS Autoprefixer and SVG inline icons to enhance development efficiency.

- For a full description of the theme, visit the project page:
  https://www.drupal.org/project/belgrade

- To submit bug reports and feature suggestions, or track changes:
  https://www.drupal.org/project/issues/belgrade

## INSTALLATION

- Install as you would normally install a contributed Drupal theme. Visit
  https://www.drupal.org/node/1897420 for further information.

## CREATING A THEME FROM STARTERKIT

Belgrade can be used as a starterkit to generate a new standalone theme. This creates a completely
independent theme (not a subtheme) based on Belgrade's structure.

### Generating a Theme from Starterkit

To create a new theme from Belgrade starterkit, use Drupal's theme generator:

```bash
php web/core/scripts/drupal generate-theme --starterkit=belgrade your_theme_name
```

Replace `your_theme_name` with your desired theme machine name. The generator will:
- Create a new theme directory in `web/themes/custom/`
- Copy relevant files from Belgrade
- Set up the theme as a standalone theme (not a subtheme)
- Exclude certain files (like `macros.twig`) that should reference the base theme

### What Gets Excluded

**Not copied to generated theme (references base theme):**
- `templates/macros.twig` - Icon macro references base theme path for proper icon loading

**Copied to generated theme:**
- All template files (which you can customize)
- SCSS files (which you can modify)
- Theme configuration files
- Other theme assets

## CREATING A SUBTHEME

A subtheme extends Belgrade and inherits its functionality while allowing you to override specific
parts. This is different from using the starterkit - a subtheme has `base theme: belgrade` in its
info.yml file.

### Creating a Subtheme Manually

1. Create a new directory: `web/themes/custom/your_subtheme_name`
2. Create `your_subtheme_name.info.yml`:
```yaml
name: Your Subtheme Name
type: theme
base theme: belgrade
core_version_requirement: ^10 || ^11
regions:
  navigation: 'Navigation'
  top_bar: 'Top bar'
  header: 'Header'
  highlighted: 'Highlighted'
  help: 'Help'
  content: 'Content'
  sidebar_first: 'Primary'
  sidebar_second: 'Secondary'
  footer: 'Footer'
  page_top: 'Page top'
  page_bottom: 'Page bottom'
  hidden: 'HIDDEN'
```

**Important:** Regions are not inherited from the base theme. You must define all regions in your subtheme's `.info.yml` file. Copy the regions section from `belgrade.info.yml` to ensure all regions are available.

3. Optionally create `your_subtheme_name.theme` for custom PHP functions

### Overriding Icons

The icon macro (`macros.twig`) is inherited from the base theme by default, which ensures icons
always load from the correct location. You have several options for customizing icons:

**Option 1: Use the path parameter (per-call override)**
```twig
{# Use belgrade icons (default) #}
{{ svg.getIcon('cart', 18, 18) }}

{# Use all Bootstrap icons #}
{{ svg.getIcon('cart', 18, 18, '', '', '', '/themes/contrib/belgrade/images/bootstrap-icons.svg') }}

{# Use custom subtheme icons #}
{{ svg.getIcon('cart', 18, 18, '', '', '', '/themes/custom/your_subtheme/images/custom-icons.svg') }}
```

**Option 2: Copy and modify macros.twig (global override)**
1. Copy `/themes/contrib/belgrade/templates/macros.twig` to `/themes/custom/your_subtheme/templates/macros.twig`
2. Modify the default path in the copied file
3. All icon calls will use your custom path

### Best Practices

1. **Don't modify base theme files** - Always work in your theme/subtheme directory
2. **Use template suggestions** - Override specific templates rather than copying everything
3. **Leverage theme inheritance** - Let the base theme handle common functionality
4. **Test after base theme updates** - Ensure your customizations still work after updating Belgrade

## CONFIGURATION

The Belgrade theme offers various configuration options to customize its appearance. To access the
theme settings:

1. Log in to your Drupal administration panel.
2. Go to Appearance in the admin menu.
3. Find the Belgrade theme and click on the Settings link.

### Customization Options

#### Font Settings

You can easily change the font used throughout your site with the Belgrade theme. Follow these steps
to adjust the font:

1. Go to Appearance and click on the Settings link for the Belgrade theme.
2. Look for the Font Settings section.
3. Choose the desired font from the available options.

#### Region/Layout Adjustments

The Belgrade theme provides flexibility in adjusting the layout of your site. To make layout
adjustments:

1. Go to Appearance and click on the Settings link for the Belgrade theme.
2. Locate the Regions section.
3. Use the options provided to modify the layout, including extened configuration for the offcanvas
   navigation region.

- Change the direction of the offcanvas navigation.
- Control the visibility of the logo within the offcanvas navigation.
- Configure body scrolling behavior when the offcanvas menu is open.
- Choose backdrop options for the offcanvas navigation.

#### Message Styling

Customize the messages displayed to users with the Belgrade theme. To style the messages:

1. Go to Appearance and click on the Settings link for the Belgrade theme.
2. Find the Message Styling section.
3. Customize the message styles according to your preference.

### SVG Integration

The theme offers advanced support for scalable vector graphics (SVG), allowing you to utilize SVG
seamlessly within your site.

## BUILD TOOLS

The Belgrade Drupal Theme uses modern build tools to streamline frontend development. Here's what
you need to know:

### Prerequisites

- Node.js (check version in `.nvmrc`)
- npm

### Installation

```bash
npm install
```

### Available Commands

```bash
# Watch SCSS files and rebuild on changes
npm run watch

# Build assets (CSS)
npm run build

# Generate SVG sprite
npm run icons-sprite

# Lint SCSS files
npm run lint:scss

# Format files (SCSS, JSON, MD)
npm run format
```

### Build Process

The build process includes:

1. SCSS Compilation
   - Uses Sass 1.32.13 (compatible with Bootstrap 5.3.3)
   - Includes source maps
   - Loads from node_modules

2. PostCSS Processing
   - Autoprefixer for browser compatibility
   - SVG inline support

3. SVG Sprite Generation
   - Creates a single sprite from SVGs in the `icons` folder
   - Usage: `svg-sprite --svg-namespace-classnames false`

### SVG Integration

To use inline SVGs in SCSS:

```scss
background: svg-load('PATH_TO_IMAGE', fill=#{$COLOR_VARIABLE});
```

Note: The svg-load() function only overrides attributes in the root `<svg>` element. Child elements
inherit the color unless explicitly set.

## MAINTAINERS

Current maintainers:

- Ivan Buišić (majmunbog) - https://www.drupal.org/u/majmunbog
