<?php

namespace Drupal\better_taxonomy;

use Drupal\taxonomy\VocabularyListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

class VocabularyOverrideListBuilder extends VocabularyListBuilder {

  /**
   * {@inheritdoc}
   */
  public function getDefaultOperations(EntityInterface $entity): array {
    $operations = parent::getDefaultOperations($entity);
    $operations['delete_all'] = [
      'title' => $this->t('Delete all terms'),
      'weight' => 100,
      'url' => Url::fromRoute(
        'better_taxonomy.delete_all',
        ['taxonomy_vocabulary' => $entity->id()]
      ),
    ];
    return $operations;
  }

}
