(function ($, Drupal,once) {
  Drupal.behaviors.referencePreviewDestroyLinks = {
    attach: function attach(context) {
      function clickPreviewModal(event) {
        if (event.button === 0 && !event.altKey && !event.ctrlKey && !event.metaKey && !event.shiftKey) {
          event.preventDefault();
          var $previewDialog = $('<div>' + Drupal.theme('referencePreviewModal') + '</div>').appendTo('body');
          Drupal.dialog($previewDialog, {
            title: Drupal.t('Leave preview?'),
            buttons: [{
              text: Drupal.t('Cancel'),
              click: function click() {
                $(this).dialog('close');
              }
            }, {
              text: Drupal.t('Leave preview'),
              click: function click() {
                window.top.location.href = event.target.href;
              }
            }]
          }).showModal();
        }
      }

      var $preview = $(once('reference-preview', context));
      if ($(context).find('.reference-preview-container').length) {
        $preview.on('click.preview', 'a:not([href^="#"], .reference-preview-container a)', clickPreviewModal);
      }
    },
    detach: function detach(context, settings, trigger) {
      if (trigger === 'unload') {
        var $preview = $(context).find('.content').removeOnce('reference-preview');
        if ($preview.length) {
          $preview.off('click.preview');
        }
      }
    }
  };

  Drupal.behaviors.referencePreviewSwitchViewMode = {
    attach: function attach(context) {
      var $autosubmit = $(once('autosubmit', context).find('[data-drupal-autosubmit]'));
      if ($autosubmit.length) {
        $autosubmit.on('formUpdated.preview', function () {
          $(this.form).trigger('submit');
        });
      }
    }
  };

  Drupal.theme.referencePreviewModal = function () {
    return '<p>' + Drupal.t('Leaving the preview will cause unsaved changes to be lost. Are you sure you want to leave the preview?') + '</p><small class="description">' + Drupal.t('CTRL+Left click will prevent this dialog from showing and proceed to the clicked link.') + '</small>';
  };
})(jQuery, Drupal, once);
