<?php

namespace Drupal\bibcite_entity;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the reference type entity type.
 *
 * @see \Drupal\bibcite_entity\Entity\ReferenceType
 */
class ReferenceTypeAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view bibcite_reference');

      default:
        return parent::checkAccess($entity, $operation, $account);
    }
  }

}
