# Bibcite Footnotes

## Contents

 * Introduction
 * Installation
 * Use
 * Development
 * Current Maintainers

## Introduction

This module provides a CKEditor5 plugin that lets a user select from a list of references to Bibliography & Citation][1] reference entities which
will then appear both inline as citations and as a bibliography below the content.

## Installation

### Requirements

- Bibliography & Citation (3.0.x version)
- Inline Entity Form (Recommended)

Install as normal, which will also enable the dependent modules Bibcite and Bibcite
Enable the Insert Citations button in CKEditor5:

1. Go to Administration > Configuration > Text Formats andd Editors and edit a format.
2. Move "Insert Citation" into the active toolbar.
3. Enable the "Convert bibcite-footnote tags to rendered citations." filter.
4. Customize the filter's settings in the "Inline citation filter" section.

### Works Cited field

1. Go to Administration > Structure > Content Types and edit the type that will include Reference Footnotes
2. In the Manage Fields tab, press Add Field.
3. In "Re-use an existing field" select "Entity reference: field_bibcite_fn_works_cited".
4. Enter an appropriate label and press 'Save and continue'.
5. On the next page select all the items in "Reference type" that should be available to choose from as footnotes.
6. Customize the field under "Manage form display" and "Manage display",
7. Since the bibliography is rendered directly in the Body, choose 'Disabled' for
the Works Cited field's display position.

#### Inline Enity Form

It's recommended to also install [Inline Entity Form][1] which allowes a user to
create new references directly in the node edit form.

1. In "Entity Form Display", select "Inline Entity Form - complex".
2. Press the settings button in the rightmost column.
3. Enabling  "Allow users to add new reference entities" and
   "Allow users to add existing reference entities" is recommended.

[2]: https://www.drupal.org/project/inline_entity_form

## Use

See the documentation for [Bibliography and Citation - Import][3] module for how to
add citations exported from a citation management system like RefWorks, EndNote, or Zotero.

If a user has permission to use Bibcite Import
a link will appear below the Works Cited field
in the node edit form.

[3]: https://www.drupal.org/project/bibcite

### Adding a Works Cited item

If Inline Entity Form is enabled, an author can create new citations or add references to
previously-imported or created references directly with the 'Add new reference' and
'Add existing reference' buttons.

With Inline Entity Form, newly-added citations are immediately selectable in the
Reference Footnotes dialog.

If not using the inline entity form, you can select previously imported or created references and save the node. When you edit the node again, and you click on the 'Insert Citation' editor toolbar button,
a list of citations will be available to choose from.

### Citation Formatting

The Default style selected in the
Bibliography & Citation administration pages at Administration > Configuration >
Bibliography & Citation > Settings in the Processing tab under Processor.'
will be used as the format for all citations and bibliographies.

## Development

This module includes a custom CKEditor5 plugin that requires building with Webpack.

### Prerequisites

- Node.js (version 14 or higher recommended)
- Yarn package manager

### Building the CKEditor5 Plugin

#### Development Build

For development with source maps and unminified code:

```bash
yarn install
yarn build:dev
```

This creates development builds in the js/ directory.

Next you'll need to edit bibcite_footnotes.libraries.yml.

```yaml
  js:
    js/build/bibciteFootnotes.js: { minified: true }
    # Swap out the below for development build.
    #js/bibciteFootnotes.js: { minified: false }

```

### Production Build

For optimized, minified production code:

```bash
yarn install
yarn build
```

This creates production builds in the js/build/ directory.

## Project Structure

js/ckeditor5_plugins/
└── bibciteFootnotes/
    ├── src/
    │   ├── index.js          # Plugin entry point
    │   ├── bibciteFootnotes.js  # Main plugin class
    │   └── bibciteFootnotes.css # Plugin styles
    └── ...

js/
├── bibciteFootnotes.js       # Development build
└── build/
    └── bibciteFootnotes.js   # Production build

### Adding New CKEditor5 Plugins

To add additional CKEditor5 plugins:

1. Create a new directory under js/ckeditor5_plugins/

2. Add your plugin source files in the src/ subdirectory

3. The build system will automatically detect and build all plugins

###  Dependencies Management

Keep dependencies updated with:

```bash
yarn outdated          # Check for outdated packages
yarn upgrade           # Upgrade to latest compatible versions
```

### PHP code files


├── bibcite_footnotes_article_with_citations/ (Example module with exported configuration.)
├── bibcite_footnotes.ckeditor5.yml (CKEditor5 plugin devinition)
├── bibcite_footnotes.info.yml
├── bibcite_footnotes.libraries.yml
├── bibcite_footnotes.module
├── bibcite_footnotes.services.yml
├── composer.json
├── config
│   └── optional
│       └── field.storage.node.field_bibcite_fn_works_cited.yml (Field with Bibcite Entity references, not required to be used.)
├── css
│   └── reference_footnote.css
│   └── replace_citations.js
├── LICENSE
├── package.json
├── README.md
├── src
│   ├── CitationTools.php
│   ├── InlineCitationStyler.php (Modified Bibcite styler to support inline citations.)
│   ├── Plugin
│   │   ├── BibCiteProcessor
│   │   │   └── CiteprocPhpInline.php (Customized wrapper for CiteProcPHP library calls.)
│   │   ├── CKEditor5Plugin
│   │   │   └── BibciteFootnotes.php
│   │   ├── Filter
│   │   │   └── ReferenceFootnotesFilter.php (Renders the citation and bibliography content.)
│   │   └── views
│   │       └── style
│   │           └── WorksCited.php (Render a list of Bibcite Reference entities as formatted bibliography.)
│   └── WorksCitedStyler.php (Modified Bibcite styler plugin for bibliography lists.)
├── templates
│   ├── bibcite-footnote-link.html.twig
│   ├── bibcite-footnote-list.html.twig
│   ├── bibcite-footnotes-citation.html.twig
│   ├── bibcite-footnotes-list.html.twig
│   ├── bibcite-footnotes-works-cited.html.twig
│   └── views-style-bibcite-footnotes-works-cited.html.twig

## Current Maintainers

 * Alexander O'Neill (https://www.drupal.org/u/alxp)

## Sponsors

 * This work is supported by the [University of Prince Edward Island Robertson Library](https://library.upei.ca).
 It was created to provide citations for the [Journal of Lucy Maude Montgomery Studies](https://journaloflmmontgomerystudies.ca).
