<?php

declare(strict_types=1);

namespace Drupal\bibcite_footnotes\Plugin\views\style;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\views\Attribute\ViewsStyle;
use Drupal\views\Plugin\views\style\StylePluginBase;

/**
 * Bibcite Works Cited List style plugin.
 */
#[ViewsStyle(
  id: 'bibcite_footnotes_works_cited',
  title: new TranslatableMarkup('Bibcite Works Cited List'),
  help: new TranslatableMarkup('@todo Add help text here.'),
  theme: 'views_style_bibcite_footnotes_works_cited',
  display_types: ['normal'],
)]
final class WorksCited extends StylePluginBase {

  /**
   * {@inheritdoc}
   */
  protected $usesRowPlugin = TRUE;

  /**
   * {@inheritdoc}
   */
  protected $usesRowClass = TRUE;

  /**
   * {@inheritdoc}
   */
  protected function defineOptions(): array {
    $options = parent::defineOptions();
    $options['wrapper_class'] = ['default' => 'item-list'];
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state): void {
    parent::buildOptionsForm($form, $form_state);
    $form['wrapper_class'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Wrapper class'),
      '#description' => $this->t('The class to provide on the wrapper, outside rows.'),
      '#default_value' => $this->options['wrapper_class'],
    ];
  }

  public function render() {
    $references = [];
    $serializer = \Drupal::service('serializer');

    foreach ($this->view->result as $row) {
      $data = $serializer->normalize($row->_entity, 'csl');
      $references[] = $data;
    }


    return ['#theme' => 'bibcite_footnotes_works_cited', '#data' => $references];
  }
}


