<?php

namespace Drupal\bibcite_footnotes;

use Drupal\bibcite\CitationStyler;
use Drupal\bibcite\Entity\CslStyleInterface;
use Drupal\bibcite\Plugin\BibCiteProcessorInterface;
use Drupal\Component\Plugin\PluginManagerInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Language\LanguageManagerInterface;

/**
 * Render CSL data to works cited bibliography.
 */
class WorksCitedStyler extends CitationStyler
{
  protected $filterSettings = [];

  public function setFilterSettings(array $settings)
  {
    $this->filterSettings = $settings;
  }

  public function getCssStyles()
  {
    $csl = $this->getStyle()->getCslText();
    $lang = $this->getLanguageCode();

    return $this->getProcessor()->renderCssStyles($csl, $lang);
  }

  /**
   * {@inheritdoc}
   */
  public function render($data, $citation_items = False)
  {
    $csl = $this->getStyle()->getCslText();
    $lang = $this->getLanguageCode();

    // Pass filter settings to the processor
    $this->getProcessor()->setFilterSettings($this->filterSettings);

    return $this->getProcessor()->render($data, $csl, $lang, 'bibliography', $citation_items);
  }
}
