<?php

namespace Drupal\Tests\bibcite_footnotes\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\bibcite_footnotes\CitationTools;
use Drupal\Tests\bibcite_entity\Traits\EntityCreationTrait;

/**
 * Kernel tests for CitationTools service.
 *
 * @group bibcite_footnotes
 */
class CitationToolsTest extends KernelTestBase
{

  use EntityCreationTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'field',
    'text',
    'user',
    'bibcite',
    'bibcite_entity',
    'bibcite_footnotes',
    'serialization',
  ];

  /**
   * The citation tools service.
   *
   * @var \Drupal\bibcite_footnotes\CitationTools
   */
  protected $citationTools;

  /**
   * Test reference entity.
   *
   * @var \Drupal\bibcite_entity\Entity\ReferenceInterface
   */
  protected $reference;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void
  {
    parent::setUp();

    $this->installEntitySchema('user');
    $this->installEntitySchema('bibcite_reference');
    $this->installEntitySchema('bibcite_contributor');
    $this->installEntitySchema('bibcite_keyword');
    $this->installConfig(['bibcite', 'bibcite_entity']);

    // Create a test reference.
    $this->reference = $this->createReference([
      'title' => 'Test Reference',
      'bibcite_year' => 2020,
      'type' => 'journal_article',
    ]);

    $this->citationTools = $this->container->get('bibcite_footnotes.citation_tools');
  }

  /**
   * Tests service instantiation.
   */
  public function testServiceInstantiation()
  {
    $this->assertInstanceOf(CitationTools::class, $this->citationTools);
  }

  /**
   * Tests getRenderableReference with entity ID.
   */
  public function testGetRenderableReferenceWithId()
  {
    $result = $this->citationTools->getRenderableReference($this->reference->id());

    $this->assertIsArray($result);
    $this->assertArrayHasKey('#theme', $result);
    $this->assertEquals('bibcite_footnotes_citation', $result['#theme']);
    $this->assertArrayHasKey('#data', $result);
  }

  /**
   * Tests getRenderableReference with entity object.
   */
  public function testGetRenderableReferenceWithEntity()
  {
    $result = $this->citationTools->getRenderableReference($this->reference);

    $this->assertIsArray($result);
    $this->assertArrayHasKey('#theme', $result);
    $this->assertEquals('bibcite_footnotes_citation', $result['#theme']);
    $this->assertArrayHasKey('#data', $result);
  }

  /**
   * Tests getRenderableReference with invalid ID.
   */
  public function testGetRenderableReferenceInvalidId()
  {
    $result = $this->citationTools->getRenderableReference(9999);

    // Should return a render array even for invalid IDs
    $this->assertIsArray($result);
    $this->assertArrayHasKey('#theme', $result);
    $this->assertEquals('bibcite_footnotes_citation', $result['#theme']);
  }
}
