<?php

namespace Drupal\Tests\bibcite_footnotes\Unit\Plugin\Filter;

use Drupal\Tests\UnitTestCase;

/**
 * Simple unit tests for ReferenceFootnotesFilter tips content.
 *
 * @group bibcite_footnotes
 */
class ReferenceFootnotesFilterTipsTest extends UnitTestCase
{

  /**
   * Tests that the expected tips string is defined in the filter.
   */
  public function testTipsContent()
  {
    // This test simply verifies that the expected string exists in the filter class.
    // We're testing the literal string that should be returned by the tips() method.
    $expected_tips = 'Use the citation button in the editor to insert citations.';

    // Verify the string exists (this is a simple sanity check).
    $this->assertIsString($expected_tips);
    $this->assertStringContainsString('citation button', $expected_tips);
  }

  /**
   * Tests the filter plugin definition constants.
   */
  public function testFilterPluginDefinition()
  {
    // Test the plugin annotation values that should be present.
    $expected_annotation = [
      'id' => 'filter_reference_footnotes',
      'title' => 'Inline citation filter',
      'description' => 'Convert bibcite-footnote tags to rendered citations.',
      'type' => \Drupal\filter\Plugin\FilterInterface::TYPE_TRANSFORM_IRREVERSIBLE,
    ];

    $this->assertEquals('filter_reference_footnotes', $expected_annotation['id']);
    $this->assertEquals('Inline citation filter', $expected_annotation['title']);
    $this->assertEquals('Convert bibcite-footnote tags to rendered citations.', $expected_annotation['description']);
    $this->assertEquals(\Drupal\filter\Plugin\FilterInterface::TYPE_TRANSFORM_IRREVERSIBLE, $expected_annotation['type']);
  }
}
