<?php

namespace Drupal\bibliocommons\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class BibliocommonsForm for saving bilbiocommons config.
 */
class BibliocommonsForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'bibliocommons_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = self::config('bibliocommons.settings');
    $form = [];

    $form['bib_api_key'] = [
      '#title' => $this->t('Api Key'),
      '#type' => 'key_select',
      '#required' => TRUE,
      '#default_value' => $config->get('api_key'),
    ];

    $form['bib_library'] = [
      '#title' => $this->t('Bibliocommons Library ID'),
      '#type' => 'textfield',
      '#size' => 60,
      '#maxlength' => 128,
      '#required' => TRUE,
      '#default_value' => $config->get('library_id'),
    ];

    $form['bib_client_id'] = [
      '#title' => $this->t('Syndetics Client ID'),
      '#type' => 'textfield',
      '#size' => 60,
      '#maxlength' => 128,
      '#required' => TRUE,
      '#default_value' => $config->get('client_id'),
    ];

    $form['submit'] = [
      '#prefix' => '<div class="input-submit">',
      '#suffix' => '</div>',
      '#type' => 'submit',
      '#value' => $this->t('Save Configuration'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    // If invalid input is passed the books will return an empty array.
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = self::configFactory()->getEditable('bibliocommons.settings');

    $config->set('client_id', $form_state->getValue('bib_client_id'));
    $config->set('library_id', $form_state->getValue('bib_library'));
    $config->set('api_key', $form_state->getValue('bib_api_key'));

    $config->save();
  }

}
