<?php

namespace Drupal\bibliocommons\Plugin\WSEncoder;

use Drupal\wsdata\Plugin\WSEncoderBase;

/**
 * Api Request Encoder.
 *
 * @WSEncoder(
 *   id = "ApiRequestEncoder",
 *   label = @Translation("Api Request Encoder", context = "WSEncoder"),
 * )
 */
class ApiRequestEncoder extends WSEncoderBase {

  /**
   * {@inheritdoc}
   */
  public function encode(&$data, &$replacement, &$url) {
    if ($url && $replacement && count($replacement) > 0 && is_array($data)) {
      // Append Global settings.
      $apiKey = array_key_exists('api_key', $data) ? $data['api_key'] : '';
      $locale = array_key_exists('locale', $data) ? $data['locale'] : '';
      $library = array_key_exists('library', $data) ? $data['library'] : '';

      // Check if we are appending a query string or adding a new query string.
      $queryStart = str_contains($url, "?") ? '&' : '?';
      $url = $url . $queryStart . "library=$library&locale=$locale&api_key=$apiKey";
    }
  }

}
