<?php
/**
 * Allows modules to alter the BigBlueButton meeting role.
 *
 * @param string &$role
 *   The role assigned to the current user. Expected values: 'moderator', 'viewer'.
 *   Modules may override this to influence meeting permissions.
 * @param \Drupal\Core\Entity\EntityInterface $entity
 *   The BBB entity for which the role is being assigned.
 * @param \Drupal\Core\Session\AccountInterface $account
 *   The current user account.
 */
function hook_bigbluebutton_meeting_role_alter(&$role, \Drupal\Core\Entity\EntityInterface $entity, \Drupal\Core\Session\AccountInterface $account) {
  // Example: Force all users with a certain permission to be viewers.
  if ($account->hasPermission('never_join_as_moderator')) {
    $role = 'viewer';
  }
}
