<?php declare(strict_types = 1);

namespace Drupal\bigbluebutton\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\Component\Utility\UrlHelper;
use Drupal\Component\Utility\Environment;
use Drupal\file\Entity\File;

/**
 * Configure Bigbluebutton settings for this site.
 */
final class ButtonLabelsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'bigbluebutton_button_lables';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['bigbluebutton.button_labels'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {

    $form['join_meeting'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Join meeting button label'),
      '#default_value' => $this->config('bigbluebutton.button_labels')->get('join_meeting'),
      '#required' => TRUE
    ];


    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state): void {   
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {  
    $this->config('bigbluebutton.button_labels')
      ->set('join_meeting', $form_state->getValue('join_meeting'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
