<?php

namespace Drupal\bigbluebutton\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Routing\TrustedRedirectResponse;
use BigBlueButton\Parameters\JoinMeetingParameters;
use Drupal\bigbluebutton\BBB;


/**
 * Defines Virtual Event BBB Link Form.
 */
class BBBLinkForm extends FormBase {


  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    static $num = 0;
    $num++;

    return 'bbb_link_form_' . $num;

  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, $settings = null) {


    // Check the current user
    $user = \Drupal::currentUser();

    // Get config for the button labels.
    $config = $this->config('bigbluebutton.button_labels');
    $join_meeting_label = $config->get('join_meeting');

    // We want to display our button when 
    // BBB enabled only!
    
    if ($settings['bbb']['enabled']) {
      $form['submit'] = [
        '#type' => 'submit',
        '#value' => $join_meeting_label,
        '#attributes' => ['class' => [$settings['link_classes']]],
      ];
      $form['entity_type_id'] = [
        '#type' => 'hidden',
        '#value' => $settings['entity']->getEntityTypeId() ? $settings['entity']->getEntityTypeId() : '',
      ];
      $form['entity_id'] = [
        '#type' => 'hidden',
        '#value' => $settings['entity']->id() ? $settings['entity']->id() : '',
      ];      
    }

    $form['#attributes'] = ['target' => '_blank'];

    return $form;

  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    foreach ($form_state->getValues() as $key => $value) {
      // @todo Validate fields.
    }
    parent::validateForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    // Get the hidden values form the form.
    $entity_type_id = $form_state->getValue('entity_type_id');
    $entity_id = $form_state->getValue('entity_id');
    $entity = \Drupal::entityTypeManager()->getStorage($entity_type_id)->load($entity_id);

    if ($entity instanceof ContentEntityInterface) {

      try {
        $join_link = \Drupal::service('bigbluebutton.helper')->generateJoinMeetingLink($entity);
      }
      catch (\RuntimeException $exception) {
        $this->getLogger('bigbluebutton')->warning($exception->getMessage());
        $error_message = $this->t("Couldn't get meeting join link! please contact system administrator.");
        $this->messenger()->addError($error_message);
      }
      catch (\Exception $exception) {
        $this->getLogger('bigbluebutton')->warning($exception->getMessage());
        $error_message = $this->t("Couldn't get meeting join link! please contact system administrator.");
        $this->messenger()->addError($error_message);
      }  

      if (isset($join_link) && $join_link['link'] !== 'disabled') {
        $url = $join_link['link'];
        $form_state->setResponse(new TrustedRedirectResponse($url));
      } 

    }
    else {
      $this->getLogger('bigbluebutton')->warning('Submitted entity is not a ContentEntityInterface, therefore cannot submit join link.'); 
    }
  }
}

