# Bistro

Bistro is a recipe for restaurants, pubs, cafés, food carts, and other food/drink establishments that provides restaurant menu capabilities. Use this whether you want a simple menu on your web site or want to create rich media menus with complex layouts using Layout Builder and Paragraphs.

> **Tip**: Apply the [Locations](https://drupal.org/project/locations) recipe to add your establishment with address and phone. With Bistro, Locations, and a Standard Drupal or Drupal CMS installation, you can make a complete web site for your food or drink establishment in minutes!

## Getting started

> **Tip**: Make sure to [clear your cache](https://www.drupal.org/docs/user_guide/en/prevent-cache-clear.html) after applying the recipe if the “Menu” link is not displayed in the “Main navigation” menu.

If you’re starting from scratch, visit the [Taxonomy](https://www.drupal.org/docs/user_guide/en/structure-taxonomy.html) administrative page. Bistro provides two vocabulary to help describe your Menu items.

- **Menu Category** — A classification to group each Menu item e.g. Appetizers.
- **Dietary Category** — A classification to describe the Menu item including uploading optional icons e.g. Spicy or Vegan.

Next, create the _Menu item_ content by visiting the Administration > Content page, pressing the "Add content” button, and following the “Menu item” link.

Fill-in the form fields to describe your Menu item:

- **Name** — Provide a descriptive name e.g. “Deep mediterranean quiche”.
- **Menu Group** — Choose the Menu category above.
- **Menu Code** — Provide a short code if your restaurant uses short codes for menu items e.g. A13.
- **Dietary Category** — Choose any options based on the Dietary category above.
- **Price** — Enter a price or description of cost e.g. “$4.50”, “varies”, “seasonal pricing”.
- **Description** — Provide a description of the item including ingredients or options.
- **Calories** — Optionally provide nuitritional information.
- **Menu Image** — Optionally upload or choose an existing image if your menu uses images.

Press Save when you’re finished!

Visit the “Menu” link in the “Main navigation” menu. This will display the menu items grouped by Menu Category in a table similar to a physical menu by default.

But you do not need to be restricted by this Menu display!

## Change the Menu display

Bistro comes with a few different ways to display Menu items, but you can play around with the “Menu (Traditional)” view using the [Views user interface](https://www.drupal.org/docs/user_guide/en/views-concept.html) to change how the Menu is dipslayed.

For instance, if you use a ”Stacked menu” that displays the Menu item and price on one line with the description below, then you can easily switch the Menu page.

1. Edit the ”Menu (Traditional)” view.
2. Follow the ”Table Menu (page)” tab link and disable that view display.
3. Follow the “Stacked Memnu (page)” tab link and enable that view display.
4. Press the Save button.

Visit the Menu page again.

## Create Custom Menu layouts

This is all great, but what about creating a Menu that has either a subset of Menu items i.e. a Lunch Menu or a Menu with a custom layout?

Bistro provides the _Custom Menu_ content type. A Custom Menu has the following fields:

-**Menu Name** — Describes the Menu e.g. Lunch Menu
-**Menu Description** — Allows you to provide arbitrary rich content.
-**Menu Item Section** — Allows you to add multiple items that can be arranged after you save this content such as
   - **Menu Image** — Add _flair_ to your menu in the form of an image.
   - **Menu Items** — Add a subset of Menu items by Menu Category e.g. provide ”Appetizers” as the _Argument_ to the “Menu (Traditional)” listing.

When adding Menu Item Sections, provide an Admin title for each one so you can more easily find it when creating your layout.

After you save your Custom Menu, follow the ”Layout” link to access the Layout Builder user interface. You may use the ”Add block” links to add individual Menu Item Sections into various sections.

## What’s next?

This is only the beginning.

Use Drupal to build an amazing web site. Create an “Our Story” page using the default Basic page content provided by Drupal CMS. Add a photo gallery. Add links to your socials. Spruce up your search engine optimization (SEO) with Drupal CMS.

## Dependencies

- [Paragraphs](https://drupal.org/project/paragraphs)
- [Paragraph Blocks](https://drupal.org/project/paragraph_blocks)
- [Pathauto](https://drupal.org/project/pathauto)
- [View Field](https://drupal.org/project/viewfield)
