***
## <a name="contribution"></a>SUBMITTING PATCHES OR ISSUES

Please use the provided issue template to ensure your reports are technically actionable. High-quality reports allow us to maintain a standard of excellence.

* **Be Descriptive:** Use the body text for detailed explanations; keep the
title concise.
* **Translation:** If language is a barrier, please use an online translation
tool; we will work with you to understand the technical intent.

### SUBMITTING ISSUES
To ensure a rigorous technical analysis, please:

* **Provide Context:** Include library versions, related module versions, and
your active theme.
* **Verify Assets:** Ensure the Slick library is correctly loaded and not
returning a 404.
* **Isolate Variables:** Switch to a core theme (e.g., Olivero or Bartik) and
use default formatters to rule out custom overrides.
* **Sync Branches:** Ensure related modules are on matching or compatible
branches.
* **Search First:** Check the issue queue for duplicates.
* **Categorize:** When in doubt, file as a **Support Request**. Valid bugs
will be re-categorized by maintainers upon verification.

### SUBMITTING PATCHES
A patch is a contribution toward collective excellence. To ensure a successful
merge:

* **Document Intent:** Use the issue body to provide a thorough technical
explanation. Patches without explanatory context will be deferred.
* **Reference Standards:** Provide links to official Drupal Change Records or documentation, especially for coding standards.
* **Validate:** Ensure you are working against the latest **dev branch**.
* **Consistency:** Every bug fix must include clear steps for reproduction. No reproduction, no validation.

---

## BUG REPORTS OR SUPPORT REQUESTS

A baseline understanding of Drupal site building is required. Before opening
an issue:

* Consult the README via **`/admin/help`** and review field descriptions.
* Install the samples, if provided by sub-modules, to observe a verified,
working implementation.
* Search the issue queue; many solutions are already documented.

**For Validated Bug Reports:**
Provide consistent reproduction steps, detailed environment info, and
screenshots of both the output and the administrative form.

---

## <a name="issues"></a> PROJECT HEALTH: CONSTRUCTIVE VS. NON-CONSTRUCTIVE

We prioritize and credit contributions that advance the project through
technical rigor.

1.  **Valued Contributions:** We welcome Support/Feature requests, Bug reports,
and Meta/Tasks that provide actionable data.
2.  **Issue Resolution:** If an issue is closed for lack of data, feel free to
re-open it once the required technical evidence or reproduction steps are
provided.

**The Boundary of Engagement:**
Critical feedback is welcome provided it is backed by **technical data**
(benchmarks, screenshots, or documentation). We prioritize project health and
collective time; therefore, discussions that deviate into unproductive
negativity or fail to offer actionable insights will be closed to maintain
focus.

**Reciprocity:**
We recognize that defects are part of the development process. Constructive
criticism and elegant patches help us eliminate them. We operate on a principle
of mutual respect: provide professional, data-backed insights, and you will be
credited with gratitude in our
`CHANGELOG.txt`
or [committers list](https://www.drupal.org/node/2663268/committers).

Thank you for your cooperation in maintaining a high standard of engineering.
