# Contributing to Block Content Type Visibility

Thank you for your interest in contributing to this project!

## Getting Started

1. Fork the project on Drupal.org or GitHub
2. Clone your fork locally
3. Create a feature branch from the main development branch

## Development Guidelines

### Coding Standards

This module follows Drupal coding standards. Please ensure your code complies with:

- [Drupal Coding Standards](https://www.drupal.org/docs/develop/standards/coding-standards)
- [Drupal API Documentation Standards](https://www.drupal.org/docs/develop/coding-standards/api-documentation-and-comment-standards)

### Testing Your Code

Run PHP CodeSniffer to check for coding standard violations:

```bash
phpcs --standard=Drupal,DrupalPractice .
```

Auto-fix minor coding standard issues:

```bash
phpcbf --standard=Drupal,DrupalPractice .
```

Run kernel tests:

```bash
../../../vendor/bin/phpunit tests/
```

### Commit Messages

- Use clear, descriptive commit messages
- Reference issue numbers when applicable
- Follow the format: "Issue #[issue-number] by [username]: [description]"

Example:
```
Issue #1234567 by username: Add support for entity reference fields
```

## Submitting Changes

1. Ensure all tests pass
2. Verify coding standards compliance
3. Create a patch or merge request
4. Provide a clear description of changes
5. Reference any related issues

## Reporting Issues

- Use the [Drupal.org issue queue](https://www.drupal.org/project/issues/block_content_type_visibility)
- Provide steps to reproduce
- Include Drupal version and module version
- Add relevant error messages or screenshots

## Feature Requests

We welcome feature requests! Please:

1. Check if the feature already exists or is planned
2. Create an issue with a clear use case
3. Explain the benefit to the community
4. Be open to discussion and feedback

## Code Review

All contributions will be reviewed by maintainers. Please be patient and responsive to feedback.

## Questions?

Feel free to reach out through the Drupal.org issue queue or community channels.

Thank you for contributing!
