# Block Content Type Visibility

## Overview

The Block Content Type Visibility module extends Drupal's block visibility conditions by adding content type-based visibility controls. This allows site builders to show or hide blocks based on the content type of the current node.

## Features

- **Show/Hide Toggle**: Choose to either show or hide blocks for selected content types
- **Multiple Content Type Selection**: Select one or more content types for the visibility condition
- **Standards Compliant**: Built following Drupal 11 coding standards
- **Cache Aware**: Properly implements cache contexts for optimal performance

## Requirements

- Drupal: ^11
- Core modules: Block, Node

## Installation

1. Download and place the module in your `/modules/custom` or `/modules/contrib` directory
2. Enable the module via the admin interface at `/admin/modules` or using Drush:
   ```bash
   drush en block_content_type_visibility
   ```

## Usage

1. Navigate to the Block Layout page: `/admin/structure/block`
2. Click "Place block" or configure an existing block
3. Under the "Visibility" section, expand "Content Type"
4. Choose your visibility mode:
   - **Show for the selected content types**: Block will only appear on pages of the selected content types
   - **Hide for the selected content types**: Block will appear on all pages except those of the selected content types
5. Select one or more content types using the checkboxes
6. Save the block configuration

## Example Use Cases

- Display a promotional block only on Article pages
- Hide a sidebar navigation block on Landing Page content types
- Show related content blocks only for specific content types
- Control block visibility across different content types without custom code

## Technical Details

### Plugin ID
`content_type_visibility`

### Configuration Options

- `visibility_mode`: (string) Either 'show' or 'hide'
- `content_types`: (array) Machine names of selected content types

### Cache Contexts

The module adds the 'route' cache context to ensure proper cache invalidation when navigating between different node pages.

## Development

### Coding Standards

This module follows Drupal coding standards. To check code compliance:

```bash
phpcs --standard=Drupal,DrupalPractice block_content_type_visibility/
```

### Testing

The condition plugin can be tested by:
1. Creating test blocks with different visibility configurations
2. Navigating to nodes of different content types
3. Verifying blocks appear/disappear according to configuration

## Maintainers

Current maintainer:
- [Your Name]

## License

This project is licensed under the GPL-2.0-or-later license.
