# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

### Added
- Object-oriented Hook classes for Drupal 11.1+ compatibility.
- `src/Hook/BlockContentTypeVisibilityHooks.php` implementing modern hook architecture.
- Automatic version detection for backward compatibility with Drupal 10.x and 11.0.
- PHP 8 attribute-based hook discovery (`#[Hook]` attributes).
- Comprehensive documentation in `OOP_HOOKS_MIGRATION.md`.

### Changed
- Converted `hook_block_content_access()` from procedural to OOP implementation.
- Converted `hook_help()` from procedural to OOP implementation.
- Updated `block_content_type_visibility.module` to support both legacy and modern hook systems.
- Applied Drupal 11 coding standards (PHPCS/PHPCBF compliant).
- Updated `block_content_type_visibility.info.yml` to require Drupal core 10.2 or higher.
- Improved type safety with strict type hints on all method parameters.
- Enhanced code documentation with complete PHPDoc blocks.

### Technical Details
- Procedural hooks now delegate to OOP implementation when Drupal version < 11.1.
- Single source of truth for hook logic maintained in Hook class.
- Full backward compatibility maintained - no breaking changes.
- Code follows Drupal coding standards with 2-space indentation.
- All methods include proper `@param` and `@return` annotations.

### Developer Notes
- No configuration changes required for upgrade.
- Module automatically uses appropriate hook system based on Drupal version.
- Developers can safely update without modifying custom code.
- For Drupal 11.1+, procedural hooks are not loaded, improving performance.

## [1.0.0] - Previous Release
- Initial stable release with procedural hooks.
- Support for block content type visibility conditions.
- Integration with Drupal's block placement system.
