# Adding Block Editor Support to Custom Entity Types

The Block Editor module provides an extensibility system that allows modules to add Block Editor support to their custom entity types.

## How It Works

Once an entity type is registered as supported, the Block Editor module automatically provides:
- ✅ "Enable Block Editor" checkbox on entity type forms
- ✅ "Manage Block Editor" tab when enabled (auto-generated)
- ✅ "Manage Block Editor" settings route (auto-generated)
- ✅ "Manage Block Editor" operation in entity listings
- ✅ Form handling and settings storage
- ✅ Block Editor edit routes and tabs

**Most of this happens automatically!** No routing files, no local task definitions needed.

## Current Built-in Support

The module currently provides full support for:
- **Node Types** (`node_type`)
- **Taxonomy Vocabularies** (`taxonomy_vocabulary`)
- **Block Content Types** (`block_content_type`)

## Adding Support for Custom Entity Types

### Step 1: Define a Schema

Define a schema in your module's `config/schema/[module].schema.yml`:

```yaml
# Example: Adding Block Editor support to Comment types
comment.type.*.third_party.block_editor:
  type: mapping
  label: 'Block Editor settings'
  mapping:
    enabled:
      type: boolean
      label: 'Enable Block Editor'
    template:
      type: string
      label: 'Template'
    template_lock:
      type: string
      label: 'Template lock'
    allowed_blocks:
      type: sequence
      label: 'Allowed blocks'
      sequence:
        type: string
    allowed_drupal_blocks:
      type: sequence
      label: 'Allowed drupal blocks'
      sequence:
        type: string
    allowed_image_styles:
      type: sequence
      label: 'Allowed image styles'
      sequence:
        type: string
    allowed_content_block_types:
      type: sequence
      label: 'Allowed content block types'
      sequence:
        type: string
```

### Step 2: Register Entity Type

Create a `[your_module].block_editor.yml` file in your module's root directory:

```yaml
# Example: my_module.block_editor.yml
entity_types:
  comment_type: comment
  media_type: media
```

The format is simple:
- **Keys**: Bundle entity type machine names (e.g., `comment_type`, `media_type`)
- **Values**: Content entity type machine names (e.g., `comment`, `media`)

> **Note:** In the future, we may implement schema-only detection to reduce this to a single file. However, this would require more sophisticated schema introspection that doesn't rely on Drupal's generic third_party patterns. The YAML approach also provides a foundation for future features like module-specific templates and block restrictions.

### Step 3: Clear Cache

```bash
drush cr
```

**That's it!** Your custom entity type now has full Block Editor support.

## What Happens Automatically

Once you add the schema, register the entity type, and clear cache, the Block Editor module will automatically:

### 1. **Create Settings Route**
- Pattern: `block_editor.{bundle_entity_type}.settings`
- Path: Derives from your entity's edit form route + `/block-editor-settings`
- Example: `/admin/structure/comment/manage/{comment_type}/block-editor-settings`

### 2. **Create Settings Tab**
- Adds "Manage Block Editor" tab to your bundle entity edit form
- Only appears when Block Editor is enabled for that entity
- Uses the same permissions as your entity's edit form

### 3. **Register Form Handlers**
- Adds Block Editor form handler to your content entity
- Creates edit/add routes for Block Editor

### 4. **Add Operations**
- "Manage Block Editor" link appears in entity listings (when enabled)
- "Edit" operation routes to Block Editor when enabled

### 5. **Handle Tab Visibility**
- Hides default Edit tab when Block Editor is enabled
- Manages canonical link routing for entities where canonical = edit-form

## Complete Example: Adding Comment Support

To add Block Editor support for comments, you need two simple additions:
````

## What Happens Automatically

Once you add the schema, register the entity type, and clear cache, the Block Editor module will automatically:

### 1. **Create Settings Route**
- Pattern: `block_editor.{bundle_entity_type}.settings`
- Path: Derives from your entity's edit form route + `/block-editor-settings`
- Example: `/admin/structure/comment/manage/{comment_type}/block-editor-settings`

### 2. **Create Settings Tab**
- Adds "Manage Block Editor" tab to your bundle entity edit form
- Only appears when Block Editor is enabled for that entity
- Uses the same permissions as your entity's edit form

### 3. **Register Form Handlers**
- Adds Block Editor form handler to your content entity
- Creates edit/add routes for Block Editor

### 4. **Add Operations**
- "Manage Block Editor" link appears in entity listings (when enabled)
- "Edit" operation routes to Block Editor when enabled

### 5. **Handle Tab Visibility**
- Hides default Edit tab when Block Editor is enabled
- Manages canonical link routing for entities where canonical = edit-form

## Complete Example: Adding Comment Support

To add Block Editor support for comments, you need two files:

### File 1: `comment.schema.yml`
```yaml
comment.type.*.third_party.block_editor:
  type: mapping
  label: 'Block Editor settings'
  mapping:
    enabled:
      type: boolean
      label: 'Enable Block Editor'
    template:
      type: string
      label: 'Template'
    template_lock:
      type: string
      label: 'Template lock'
    allowed_blocks:
      type: sequence
      sequence:
        type: string
    allowed_drupal_blocks:
      type: sequence
      sequence:
        type: string
    allowed_image_styles:
      type: sequence
      sequence:
        type: string
    allowed_content_block_types:
      type: sequence
      sequence:
        type: string
```

### File 2: `comment.block_editor.yml`
```yaml
entity_types:
  comment_type: comment
```

Then `drush cr` - that's all!

You'll get:
- ✅ "Enable Block Editor" checkbox on comment type forms
- ✅ "Manage Block Editor" tab (only when enabled)
- ✅ Settings route: `block_editor.comment_type.settings`
- ✅ Edit routes: `block_editor.entity.comment.edit_form`
- ✅ Add routes: `block_editor.entity.comment.add_form`
- ✅ Operations in comment type listings

## Future Plans

We're considering implementing **schema-only detection** to eliminate the need for the `*.block_editor.yml` file. This would allow modules to add Block Editor support with just a single schema definition. However, this requires more sophisticated schema introspection techniques that can reliably distinguish between explicit Block Editor schemas and Drupal's generic third_party setting patterns.

The current `*.block_editor.yml` approach also provides a foundation for future enhancements like:
- Module-specific default templates
- Custom block restrictions per module
- Integration settings and preferences
- Module-level Block Editor configuration

## Testing Your Implementation

1. **Add Schema**: Create the schema file with Block Editor configuration
2. **Add Config File**: Create the `*.block_editor.yml` with entity type mappings
3. **Clear Cache**: Run `drush cr`
4. **Check Routes**: Verify route exists: `drush route:get | grep block_editor`
5. **Check Forms**: Entity type edit forms should show "Enable Block Editor" checkbox
6. **Check Tabs**: "Manage Block Editor" tab should appear when checkbox is enabled
7. **Test Edit**: Content entities should open in Block Editor when enabled

## Advanced: Route Customization

If you need to customize the auto-generated route (e.g., different path, permissions), you can manually define it in your module's routing.yml:

```yaml
# The auto-generation will skip routes that already exist
block_editor.my_entity_type.settings:
  path: '/custom/path/{my_entity_type}/block-editor'
  defaults:
    _form: '\Drupal\block_editor\Form\EntityTypeManageForm'
    _title: 'Block Editor Settings'
  requirements:
    _custom_permission: 'TRUE'
  options:
    parameters:
      my_entity_type:
        type: entity:my_entity_type
```

The system will use your manual definition instead of auto-generating.

## Troubleshooting

### No "Manage Block Editor" tab appears

1. Verify schema pattern matches your entity's config prefix
2. Check that cache was cleared: `drush cr`
3. Verify entity type has edit form route: `entity.{type}.edit_form`

### Settings page shows 404

1. Check route exists: `drush route:get block_editor.{your_type}.settings`
2. Verify bundle entity type ID is correct
3. Clear routing cache: `drush cr`

### Checkbox doesn't appear on form

1. Verify `FormHooks::supportsBlockEditorSettings()` detects your schema
2. Check that bundle entity implements `ThirdPartySettingsInterface`
3. Verify form ID matches entity edit form

## Summary

**Before (old way):** Required 3+ files with hardcoded routes, tasks, and configuration

**Now (new way):** Just 1 schema file!

The Block Editor module is now **truly plug-and-play** for any content entity type with bundles. Just define the schema, clear cache, and everything else is automatic!

- `node_type` → `administer content types`
- `taxonomy_vocabulary` → `administer taxonomy`  
- `block_content_type` → `administer block content types`
- Custom types → `administer site configuration` (fallback)

Override by defining custom routes with your preferred permissions.

### Custom Form Integration

The Block Editor form automatically integrates with any entity type that:
1. Has the appropriate schema definition
2. Implements `ConfigEntityInterface`
3. Has third-party settings support

## Future Enhancements

The module is designed to become more dynamic in future versions:
- Automatic route generation for any schema-supported entity type
- Plugin-based entity type discovery
- More flexible path generation based on entity type patterns

For now, the combination of schema-based detection and manual routing provides a good balance of flexibility and stability.