# Block Editor Settings Implementation

## Overview
This implementation adds Block Editor settings to entity type forms with a clean UI pattern:
1. **Simple checkbox** on the main entity type form to enable/disable Block Editor
2. **Advanced settings tab** that appears only when Block Editor is enabled

## Files Created/Modified

### Core Files
- `src/Hook/FormHooks.php` - Form alterations and local task management
- `src/Form/EntityTypeManageForm.php` - Advanced settings form
- `block_editor.routing.yml` - Routes for Block Editor settings forms
- `block_editor.links.task.yml` - Local tasks (tabs) configuration
- `block_editor.services.yml` - Service definitions (updated)

### Schema
- `config/schema/block_editor.schema.yml` - Third-party settings schema

## Supported Entity Types
- **Node Types** (`node_type`)
- **Taxonomy Vocabularies** (`taxonomy_vocabulary`)  
- **Block Content Types** (`block_content_type`)

## User Experience Flow

### 1. Enable Block Editor
1. Go to entity type edit form (e.g., `/admin/structure/types/manage/article`)
2. Check "Enable Block Editor" checkbox
3. Save the form

### 2. Configure Advanced Settings
1. After saving with Block Editor enabled, a new tab "Manage Block Editor" appears
2. Click the tab to access advanced settings:
   - **Template**: JSON template for block structure
   - **Template Lock**: Control which parts users can modify (all, insert, contentOnly)
   - **Allowed Blocks**: Restrict which block types are available

### 3. Disable Block Editor
1. Uncheck "Enable Block Editor" checkbox
2. Save the form
3. The "Manage Block Editor" tab will disappear

## Technical Implementation Details

### Form Hooks
- Uses Drupal 10+ Hook attributes for modern hook implementation
- Checks schema support via `TypedConfigManagerInterface`
- Saves settings as third-party configuration
- Dynamically shows/hides local tasks based on enabled status

### Route Structure
```
/admin/structure/types/manage/{node_type}/block-editor
/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/block-editor  
/admin/structure/block/block-content/manage/{block_content_type}/block-editor
```

### Local Tasks (Tabs)
- Automatically added to supported entity type forms
- Only visible when Block Editor is enabled for that entity
- Uses `hook_menu_local_tasks_alter()` for dynamic visibility

### Configuration Storage
Settings are stored as third-party settings on the entity type:
```yaml
third_party_settings:
  block_editor:
    enabled: true
    template: '{"blocks": []}'
    template_lock: 'all'
    allowed_blocks: ['core/paragraph', 'core/heading']
```

## Testing Instructions

### Manual Testing
1. **Enable the module**: `drush en block_editor`
2. **Clear cache**: `drush cr`
3. **Test node types**:
   - Go to `/admin/structure/types/manage/article`
   - Check "Enable Block Editor"
   - Save form
   - Verify "Manage Block Editor" tab appears
   - Click tab and configure settings
4. **Test other entity types**:
   - Taxonomy: `/admin/structure/taxonomy/manage/tags`
   - Block types: `/admin/structure/block/block-content/manage/basic`

### Verification Points
- ✅ Checkbox appears on entity type forms
- ✅ Checkbox state persists after saving
- ✅ Tab only appears when enabled
- ✅ Advanced settings form works
- ✅ Settings are saved correctly
- ✅ No coding standards violations

## Code Quality
- Follows Drupal coding standards
- Uses dependency injection
- Proper error handling
- Schema validation
- Service-oriented architecture

## Future Enhancements
- Add validation for JSON template format
- Implement block type discovery for allowed blocks field
- Add preview functionality for templates
- Cache optimization for better performance