/**
 * @file
 * Block Editor form functionality.
 */

(function (Drupal) {
  'use strict';

  /**
   * Block Editor form behavior.
   */
  Drupal.behaviors.blockEditorForm = {
    attach: function (context) {
      // Add any Block Editor specific JavaScript behavior here.
      var forms = context.querySelectorAll('[data-block-editor="true"]');
      forms.forEach(function (form) {
        form.classList.add('block-editor-isolated');
        
        // Debug indicator
        if (form.dataset.debug) {
          console.log('Block Editor form isolated:', form);
        }
      });
    }
  };

})(Drupal);