<?php

namespace Drupal\block_editor\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Routing\Access\AccessInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\block_editor\Service\EntityManager;
use Symfony\Component\Routing\Route;

/**
 * Controls access to Block Editor content entity add routes.
 */
class BlockEditorAddFormAccessCheck implements AccessInterface {

  /**
   * The Block Editor entity manager.
   *
   * @var \Drupal\block_editor\Service\EntityManager
   */
  protected EntityManager $entityManager;

  /**
   * Constructs a new BlockEditorAddFormAccessCheck instance.
   */
  public function __construct(EntityManager $entity_manager) {
    $this->entityManager = $entity_manager;
  }

  /**
   * {@inheritdoc}
   */
  public function access(Route $route, RouteMatchInterface $route_match) {
    $bundle = $this->extractBundleEntity($route_match);

    if (!$bundle) {
      return AccessResult::forbidden();
    }

    if ($this->entityManager->isBlockEditorEnabledForEntity($bundle)) {
      return AccessResult::allowed()->addCacheableDependency($bundle);
    }

    return AccessResult::forbidden()->addCacheableDependency($bundle);
  }

  /**
   * Extracts the bundle config entity from the current route match.
   */
  protected function extractBundleEntity(RouteMatchInterface $route_match): ?ConfigEntityInterface {
    foreach ($route_match->getParameters() as $parameter) {
      if ($parameter instanceof ConfigEntityInterface) {
        return $parameter;
      }
    }

    return NULL;
  }

}
