/**
 * Internal dependencies
 */
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const packagesConfig = require('./tools/webpack/packages');
const vendorsConfig = require('./tools/webpack/vendors');
const wordpressPackagesConfig = require('./tools/webpack/wordpress-packages');
const GenerateDrupalLibrariesPlugin = require('./tools/webpack/generate-libraries');

// Flatten wordpress packages config (it might return an array)
const wpConfigs = Array.isArray( wordpressPackagesConfig ) ? wordpressPackagesConfig : [ wordpressPackagesConfig ];

module.exports = [
	packagesConfig,
	...vendorsConfig,
	...wpConfigs,
	{
		entry: {
			block_editor: './js/index.js',
		},
		externals: {
			Drupal: 'Drupal',
			'@blockeditor/editor': 'be.editor',
		},
		output: {
			path: `${__dirname}/build`,
			filename: '[name].js',
		},
		module: {
			rules: [
				// This ensures JSX is processed
				{
					test: /\.(js|jsx)$/,
					exclude: /node_modules/,
					use: {
						loader: 'babel-loader',
						options: {
							presets: [
								'@babel/preset-env',
								['@babel/preset-react', { runtime: 'automatic' }]
							]
						}
					}
				},
				// SASS/SCSS and PostCSS processing
				{
					test: /\.(scss|sass)$/,
					use: [
						MiniCssExtractPlugin.loader,
						'css-loader',
						{
							loader: 'postcss-loader',
							options: {
								postcssOptions: {
									plugins: [
										require('autoprefixer'),
									],
								},
							},
						},
						'sass-loader',
					],
				},
				// CSS with PostCSS
				{
					test: /\.css$/,
					use: [
						MiniCssExtractPlugin.loader,
						'css-loader',
						{
							loader: 'postcss-loader',
							options: {
								postcssOptions: {
									plugins: [
										require('autoprefixer'),
									],
								},
							},
						},
					],
				},
			],
		},
		plugins: [
			new MiniCssExtractPlugin({
				filename: '[name].css',
			}),
			new GenerateDrupalLibrariesPlugin({
				buildDir: 'build',
				outputFile: 'block_editor.libraries.yml',
			}),
		],
	}
];
