<?php

namespace Drupal\block_purge\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;

/**
 * Controller for the Block Cache Clear page.
 */
class BlockPurgeController extends ControllerBase implements ContainerInjectionInterface {

  /**
   * Displays the admin page with the form.
   */
  public function clearPage() {
    $build = [
      '#type' => 'container',
      'intro' => [
        '#markup' => $this->t('<p>This tool allows you to clear cache for slected blocks on the site.</p>'),
      ],
      'form' => $this->formBuilder()->getForm('\Drupal\block_purge\Form\BlockPurgeForm'),
    ];

    return $build;
  }

}
