<?php

namespace Drupal\Tests\block_visibility_days\Unit\Plugin\Condition;

use Drupal\block_visibility_days\Plugin\Condition\BlockVisibilityDays;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslationInterface;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * @coversDefaultClass \Drupal\block_visibility_days\Plugin\Condition\BlockVisibilityDays
 * @group block_visibility_days
 */
class BlockVisibilityDaysTest extends UnitTestCase {

  protected $plugin;

  protected function setUp(): void {
    parent::setUp();
    
    // Mock the container and translation service
    $container = $this->createMock(ContainerInterface::class);
    $translation = $this->createMock(TranslationInterface::class);
    $translation->method('translate')->willReturnArgument(0);
    $container->method('get')->with('string_translation')->willReturn($translation);
    \Drupal::setContainer($container);
    
    $this->plugin = new BlockVisibilityDays([], 'block_visibility_days', []);
  }

  /**
   * @covers ::defaultConfiguration
   */
  public function testDefaultConfiguration() {
    $config = $this->plugin->defaultConfiguration();
    $this->assertArrayHasKey('days_visibility', $config);
    $this->assertEquals('', $config['days_visibility']['days']);
  }

  /**
   * @covers ::buildConfigurationForm
   */
  public function testBuildConfigurationForm() {
    $form_state = $this->createMock(FormStateInterface::class);
    $form = $this->plugin->buildConfigurationForm([], $form_state);
    
    $this->assertEquals('fieldset', $form['days_visibility']['#type']);
    $this->assertEquals('checkboxes', $form['days_visibility']['days']['#type']);
    $this->assertCount(7, $form['days_visibility']['days']['#options']);
  }

  /**
   * @covers ::submitConfigurationForm
   */
  public function testSubmitConfigurationForm() {
    $form_state = $this->createMock(FormStateInterface::class);
    $form_state->method('getValues')->willReturn([
      'days_visibility' => ['days' => ['Mon' => 'Mon']]
    ]);
    $form = [];
    $this->plugin->submitConfigurationForm($form, $form_state);
    $config = $this->plugin->getConfiguration();
    $this->assertEquals(['Mon' => 'Mon'], $config['days_visibility']['days']);
  }

  /**
   * @covers ::evaluate
   */
  public function testEvaluate() {
    // Test empty configuration returns TRUE
    $this->plugin->setConfiguration(['days_visibility' => ['days' => []]]);
    $this->assertTrue($this->plugin->evaluate());
    
    // Test with configured days - result depends on current day
    $this->plugin->setConfiguration(['days_visibility' => ['days' => ['Mon' => 'Mon']]]);
    $result = $this->plugin->evaluate();
    $this->assertIsBool($result);
  }

  /**
   * @covers ::summary
   */
  public function testSummary() {
    $this->assertNull($this->plugin->summary());
  }

}