# Blocks Bulk Actions

## INTRODUCTION

Blocks Bulk Actions module enhances Drupal’s default **Block layout** admin page with a powerful, extensible bulk action system.  
It is based on a new `BlocksBulkActionsManager` plugin type, allowing developers to define custom bulk actions for block instances.

---

## REQUIREMENTS

This module requires no modules outside of Drupal core.

---

## INSTALLATION

Install as you would normally install a contributed Drupal module.  
Visit [https://www.drupal.org/node/1897420](https://www.drupal.org/node/1897420) for further information.

---

## CONFIGURATION

The module has no global configuration.  
Once enabled, visit **Structure → Block layout** and you will see a dropdown selector with available bulk actions to apply to block instances.

---

## DEVELOPERS

To create a custom bulk action:

1. Implement a plugin of type `BlocksBulkActionsManager`.
2. Define your plugin annotation with:
   ```php
   /**
    * @BlocksBulkActions(
    *   id = "my_custom_bulk_action",
    *   description = @Translation("My Custom Bulk Action Description")
    * )
    */
