<?php declare(strict_types = 1);

namespace Drupal\blocks_bulk_actions\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines blocks_bulk_actions annotation object.
 *
 * @Annotation
 */
final class BlocksBulkActions extends Plugin {

  /**
   * The plugin ID.
   */
  public readonly string $id;

  /**
   * The action translatable description, this will be appeared on the.
   *
   * Blocks bulk actions dropdown select.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The concerned blocks IDs, if empty array or omitted that means the.
   *
   * Action concern all blocks ids.
   *
   * @var array
   */
  public $bids;

}
