<?php declare(strict_types = 1);

namespace Drupal\blocks_bulk_actions;

use Drupal\Core\Session\AccountProxyInterface;

/**
 * Interface for blocks_bulk_actions plugins.
 */
interface BlocksBulkActionsInterface {

  /**
   * Provide the bids concerned by the Blocks Bulk Action.
   */
  public function bids(): array;

  /**
   * Implementation of action logic that should be executed on each selected.
   *
   * @param string $id
   */
  public function execute(string $id);

  /**
   * Provide the description of the Blocks Bulk Action.
   *
   * @return \Drupal\Core\Annotation\Translation
   *   blocks bulk action translatable description.
   */
  public function description();

  /**
   * Implementation of action logic that should be executed on set of selected.
   *
   * Term.
   *
   * @param array $blocks
   *   An array of $blocks ids that the action will be applied on.
   */
  public function executeMultiple(array $blocks);

  /**
   * Add the action finish message.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   *   The translatable action end message.
   */
  public function actionFinishedMessage();

  /**
   * Manage access to the blocks bulk action, return TRUE if the action is.
   *
   * Accessible.
   *
   * @param \Drupal\Core\Session\AccountProxyInterface $account
   *   Current authenticated user account object.
   *
   * @return bool
   *   A boolean value indicating within the access is accessible or not.
   */
  public function access(AccountProxyInterface $account);

}
