<?php declare(strict_types = 1);

namespace Drupal\blocks_bulk_actions;

use Drupal\blocks_bulk_actions\Annotation\BlocksBulkActions;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * BlocksBulkActions plugin manager.
 */
final class BlocksBulkActionsPluginManager extends DefaultPluginManager {

  /**
   * Constructs the object.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/BlocksBulkActions', $namespaces, $module_handler, BlocksBulkActionsInterface::class, BlocksBulkActions::class);
    $this->alterInfo('blocks_bulk_actions_info');
    $this->setCacheBackend($cache_backend, 'blocks_bulk_actions_plugins');
  }

}
