<?php declare(strict_types=1);

namespace Drupal\blocks_bulk_actions;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Base class for blocks_bulk_actions plugins.
 */
abstract class BlocksBulkActionsPluginBase extends PluginBase implements BlocksBulkActionsInterface {

  use StringTranslationTrait;

  /**
   * Implementation of action logic that should be executed on set of selected.
   *
   * Term.
   *
   * @param array $blocks
   *   An array of blocks ids that the action will be applied on.
   */
  public function executeMultiple(array $blocks) {
    foreach ($blocks as $block) {
      $this->execute($block);
    }
  }

  /**
   * Provide the description of the Blocks Bulk Action.
   *
   * @return \Drupal\Core\Annotation\Translation
   */
  public function description() {
    return $this->pluginDefinition['description'];
  }

  /**
   * Provide the bids concerned by the Blocks Bulk Action.
   *
   * @return array
   *   An array of concerned blocks ids.
   */
  public function bids(): array {
    return $this->pluginDefinition['bids'];
  }

  /**
   * Add the action finish message.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup
   *   The translatable action end message.
   */
  public function actionFinishedMessage() {
    $description = $this->description();
    return $this->t('The action "@description" execution has been finished.', ['@description' => $description]);
  }

  /**
   * Manage access logic to the blocks bulk action, return TRUE if the.
   *
   * Action should be accessible.
   *
   * @param \Drupal\Core\Session\AccountProxyInterface $account
   *   Current authenticated user account object.
   *
   * @return bool
   *   A boolean value indicating within the access is accessible or not.
   */
  public function access(AccountProxyInterface $account) {
    return TRUE;
  }


}
