<?php declare(strict_types = 1);

namespace Drupal\blocks_bulk_actions\Plugin\BlocksBulkActions;

use Drupal\block\Entity\Block;
use Drupal\blocks_bulk_actions\BlocksBulkActionsPluginBase;
use Drupal\Core\Session\AccountProxyInterface;

/**
 * Plugin implementation of the blocks_bulk_actions.
 *
 * @BlocksBulkActions(
 *   id = "blocks_bulk_action_disable",
 *   description = @Translation("Disable selected blocks")
 * )
 */
final class BlocksBulkActionsDisable extends BlocksBulkActionsPluginBase {

  public function execute(string $id) {
    if ($block = Block::load($id)) {
      $block->setStatus(FALSE);
      $block->save();
    }
  }

  /**
   * Manage access to the blocks bulk action, return TRUE if the action is.
   *
   * Accessible.
   *
   * @param \Drupal\Core\Session\AccountProxyInterface $account
   *   Current authenticated user account object.
   *
   * @return bool
   *   A boolean value indicating within the access is accessible or not.
   */
  public function access(AccountProxyInterface $account) {
    return $account->hasPermission('administer blocks');
  }

}
