---
title: Home
navigation: false
layout: page
main:
  fluid: false
---

:ellipsis{right=0px width=75% blur=150px}

::block-hero
---
cta:
  - Get started
  - /introduction/getting-started
secondary:
  - Open on Drupal.org →
  - https://www.drupal.org/project/blokkli_starterkit
---

#title
Interactive page building experience with Drupal

#description
Enjoy the powerful and elegant editing experience offered by [blokk.li](https://blokk.li), a fully interactive in-page editor based on the well-known Drupal Paragraphs module.

#extra
  ::list
  - [Out of the box support experience](/introduction/getting-started) with local setup using [Lando](https://lando.dev) or [DDEV](https://www.ddev.com)
  - Drupal Backend Setup with **GraphQL**, **Paragraphs** and **[Paragraphs blokk.li module](https://www.drupal.org/project/paragraphs_blokkli)** enabled
  - **[+40 Vue Components](/frontend/components)**  and [Composables](/frontend/composables) ready to build paragraph based Drupal websites
  - Basic Frontend setup with **Nuxt 3** and **[GraphQL Middleware](https://github.com/dulnan/nuxt-graphql-middleware)** included
  - [Multilanguage support](/drupal/multilanguage) with language negotation and translation support
  - Key-based [Texts](/drupal/multilanguage#drupal-texts-module) managed in Drupal combined with [translation extraction](/drupal/multilanguage#nuxt-easy-texts) in the frontend
  - [SVG Icon Sprite generation](/introduction/icons) with Drupal Media Library integration
  - [rokka.io Image CDN integration](/introduction/images) and [Drupal media](https://www.drupal.org/project/rokka) library integration
  - Reverse proxy [configuration generator](/tools/nginx) included
  ::

#support
  ##### Install with ddev

  ::terminal
  ---
  content:
  - git clone git@git.drupal.org:project/blokkli_starterkit.git
  - cd blokkli_starterkit
  - ./scripts/local/init-project.sh ddev 
  - ddev frontend
  ---
  ::

  ##### Install with lando

  ::terminal
  ---
  content:
  - git clone git@git.drupal.org:project/blokkli_starterkit.git
  - cd blokkli_starterkit
  - ./scripts/local/init-project.sh lando
  - lando bun run dev
  ---
  ::

  ##### Login and try blokk.li

Login under https://starterkit.ddev.site/user with the credentials (`admin` /`password`) created during the setup

Start building your first page!
::

::card-grid
#title
What's included

#root
:ellipsis{left=0px width=40rem top=10rem blur=140px}

#default
  ::card{icon=mdi:drupal}
  #title
  Decoupled Drupal Setup
  #description
  Harness the full power of the Drupal, GraphQL and Paragraphs ecosystem.
  ::

  ::card{icon=starterkit:logo}
  #title
  blökkli In-Page Editing
  #description
  Edit your content directly in the frontend with the powerful [blokk.li](https://blokk.li) in-page editor.

  ::

  ::card{icon=mdi:graphql}
  #title
  GraphQL Middleware
  #description
  Enjoy the ease and simplicity of the [Nuxt GraphQL Middleware module](https://github.com/dulnan/nuxt-graphql-middleware). Schema generation, type-safe queries and type-hints for your components.
  ::

  ::card{icon=mdi:translate}
  #title
  Multilanguage, Translation Management
  #description
  Multilanguage support from scratch: language negotiation and string translation in the frontend, translation management in Drupal.
  ::

  ::card{icon=starterkit:rokka-icon}
  #title
  rokka.io: Digital Image processing done right
  #description
  Image style handling and CDN delivery with Drupal and [Rokka.io](https://rokka.io) integration.
  ::

  ::card{icon=mdi:build-outline}
  #title
  Extensible.
  #description
  Use the blökkli starterkit as a springboard for your next project. Add your custom frontend components and Drupal Paragraphs.
  Deploy and build with ease using the included build scripts.
  ::
::
