# Getting Started

Getting up and running with the blökkli starterkit is straightforward. You can rapidly spin up a demo site on your local machine.

## Setup with DDEV

1. Follow the instruction to install DDEV on your machine (if not already installed):
   https://ddev.readthedocs.io/en/stable/users/install/ddev-installation/.
2. After installing DDEV, check if the `ddev` command is working in your terminal.
3. Make sure you have run `mkcert --install` to setup local SSL certificates.

::alert{type="info"}
:icon{name="mdi:rocket" width=2em height=2em} You are ready to use the automated setup script in the next section.
::

## Setup with Lando

1. On OSX, follow the documentation: https://docs.lando.dev/install/macos.html.
2. On Linux, follow the documentation: https://docs.lando.dev/install/linux.html
3. On Windows, install Lando inside a WSL2 enabled distro: https://docs.lando.dev/install/windows.html.
4. Check that the lando command is working in your terminal.

::alert{type="info"}
:icon{name="mdi:rocket" width=2em height=2em} You are ready to use the automated setup script in the next section.
::

## Automated Setup

This script sets up a working local environment with Drupal and Nuxt frontend in a few minutes.

It is recommended to create a free account on [rokka.io](https://rokka.io/dashboard/#/signup) and get your API key to
use the image CDN.
During the setup process, you will be asked to provide the API key and the organisation name.

### Setup rokka.io for image handling

All image handling, processing and optimization is done by rokka.io.
You can create a free account and set up a new organization at https://rokka.io/dashboard/#/signup.

You will get an API key and an organisation name.

### Run the installer

Start the script and provide the desired setup type (ddev or lando).

```bash
./scripts/local/init-project.sh (ddev | lando)
```

This will:

- Set up the necessary .env files,
- Run `composer install` within the container,
- Import the demo database,
- Upload some demo images to rokka.io and set up the image styles,
- Install all frontend dependencies with a clean state using `bun install`,
- Rebuild all styles, and
- Ask you to start the frontend in development mode.

After running the script, you can log in in the Drupal backend as usual under
`https://starterkit.ddev.site/user` (or `https://starterkit.lndo.site/user` with lando) with the credentials generated during installation. Defaults to `admin` /
`password`.

Now you can visit the frontpage and start building your first page with blökkli.
