# Architecture

## Overview

The following visualisation shows the architecture of the starterkit. Every component is explained in detail below.

[![architecture.png](/content/images/architecture.png)](/content/images/architecture.png){target="_blank"}

## Components

### Reverse Proxy (nginx)

The reverse proxy is the entry point for all incoming requests. It routes the requests to the correct service based
on the path. Requests for the frontend are routed to the Nuxt frontend, and requests for Drupal are routed to the
PHP-FPM Drupal backend service.

Because everything runs under a single domain, we can use cookies for session management and CSRF protection.

In order to simplify the routing rules, we have created a small tool to automatically created the necessary
nginx configuration files. It is called the [nginx-conf-generator](/tools/nginx). If you need to adapt the
routing rules, use the provided tool to generate the configuration files.

### Drupal Backend (PHP)

The Drupal backend is a PHP-FPM based virtual host on nginx that runs the Drupal CMS. It is responsible for handling
all content management tasks, such as creating and editing content, managing users, and managing the configuration of
the website. The Drupal backend does no rendering for the frontend. There is no theme, twig or a single preprocess hook
involved.

### Nuxt GraphQL Middleware

The middleware exposes GraphQL queries and mutations as fully typed API endpoints. It hides the Drupal GraphQL API
server from public access and prevents bundling large queries. The middleware is a crucial part of the whole setup
and available open source: [Nuxt GraphQL Middleware](https://nuxt-graphql-middleware.dulnan.net/),

### Nuxt Frontend

The Nuxt frontend is a traditional Nuxt 3 application. The starterkit comes
with a bunch of preinstalled modules to
handle [language negotiation](/drupal/multilanguage#_2-nuxt-language-negotiation),
[string translations](/drupal/multilanguage#_3-nuxt-easy-texts) and
[image handling](/introduction/images). The frontend setup
also provides composables and components that can be used to build your website. The starterkit ships with 15 example
paragraphs and a few content types as a solid starting point for your project.
