# Project Structure

The project structure follows the best-practices of Drupal and Nuxt.js. The backend (Drupal) and
the frontend (Nuxt.js) are separated into their own subdirectories.

After many years of working with different constellations, we have found that this structure works best for us.
A monorepo makes it easier to manage and deploy the project and keep the codebase clean.

## Directory Structure

This is the directory structure of the blökkli starterkit:

```bash
drupal
frontend
scripts
.ddev
lando

```

The `drupal/` directory is where the Drupal backend is located. You can find an overview of the architecture
under [Drupal Architecture](/introduction/architecture).

The `frontend/` directory is where the Nuxt.js frontend is located. Here can find more information about
the [Nuxt ecosystem](/frontend/nuxt-modules).

The `.ddev/` directory is where the DDEV configuration files are stored. You can find more information about DDEV in
the [DDEV documentation](https://ddev.readthedocs.io/en/stable/).

The `lando/` directory is where the Lando configuration files are stored. You can find more information about Lando in
the [Lando documentation](https://docs.lando.dev/).

The `scripts/` directory contains helper scripts to automate common tasks. It includes
a [nginx Configuration Generator](/tools/nginx), a script to initialize the project, and more.
