# Image Handling

All image handling, processing and optimization in the blökkli starterkit are done by [rokka.io](https://rokka.io/).
You can [create a free account](https://rokka.io/dashboard/#/signup) and set up a new organization.

[![rokka_logo.png](/content/images/rokka_logo.png)](https://rokka.io/)

You choose an organisation name and an API key will be sent by mail. No credit card is required.

Although it is not required to use rokka.io, it is highly recommended to use it for image handling. It
will make your life easier and your images faster.

## What is Rokka.io?

Rokka is a cloud-based image processing service. It allows you to upload images, create stacks and
process images on the fly. The concept of stacks is very similar to the image styles in Drupal.

We already have preinstalled the [rokka Drupal module](https://www.drupal.org/project/rokka) in the starterkit. All
images uploaded in the
Drupal backend will be automatically uploaded to rokka.io and processed. All image styles created in Drupal
will automatically be recreated as stacks on rokka.io

![rokka_module.png](/content/images/rokka_module.png)

## How do we sync the image styles of Drupal into the frontend?

We don't.

Frontend developers want to be independent of the Drupal backend. Therefore, we have created a nuxt module
that allows you to define your image style using a composable `defineImageStyle` in the code, usually in
the `<script setup lang=ts>` section of your components.

The automated setup script created two dynamic image stacks in your rokka.io account already. If you missed this step,
you can later tho this using the script under `scripts/rokka/rokka_setup.sh`.

**Example of a responsive image style**

```vue
<template>
  <div>
      <MediaImage
        v-if="media"
        v-bind="media"
        :image-style="imageStyle"
      />
  </div>
</template>


<script setup lang="ts">
  import type { MediaImageFragment } from '#graphql-operations'
  
  defineProps<{
    media?: MediaImageFragment
  }>()

  const largeImage = defineImageStyle({
    type: 'sizes',
    sizes: {
      xs: 728,
      sm: 1000,
      md: 500,
      lg: 600,
    },
  })

</script>
```

More information how to use the [Nuxt Rokka module](https://github.com/rokka-io/nuxt-module) can be found on the module
documentation page.
