# Icon Handling

The blökkli starterkit comes with two different ways of handling icons. Some icons are only used in the frontend.
These icons are handled by the [Nuxt SVG Icon Sprite module](https://github.com/dulnan/nuxt-svg-icon-sprite).

Other icons are uploaded by the editors in the Drupal backend. These icons are handled by Drupal
module [Media Icon Deliver](https://www.drupal.org/project/media_icon_deliver).
The module provides an endpoint to fetch the SVG icons from the Drupal backend.

## 1. Nuxt SVG Icon Sprite

The module provides an easy and performant way to use SVG icons in your Nuxt 3 app.
It automatically creates SVG <symbol> sprites during build and provides components and composables to use symbols.

* Aggregate all SVG files into a one or more sprite files
* Reduce bundle size and SSR rendered page size
* Full HMR support
* Provides `<SpriteSymbol>` component to render `<svg>` with `<use>`
* Loads the sprite.svg from URL (`/_nuxt/sprite.svg`)
* Typescript type checking for available symbols

### Usage

Place the icons in the folder defined in nuxt.config.ts, by default it's ./assets/icons. The name of the SVG files is
used to determine the symbol name.
If you have a file in `./assets/icons/user.svg` the sprite will contain a `<symbol>` with id `user`.

You can now use the symbol using the provided component:

```vue

<SpriteSymbol name="user" />
```

This will render the following markup:

```html

<svg>
  <use xlink:href="/_nuxt/sprite.svg#user"></use>
</svg>
```

## 2. Drupal Media Icons

The module  [Media Icon Deliver](https://www.drupal.org/project/media_icon_deliver) is already installed in the
starterkit. The starterkit has a Media type called "Icon" that allows editors to upload SVG icons.
The frontend provided a server api to fetch the icons from the Drupal backend via `media_entity_id` (mid).

The frontend also provides a component called `MediaIcon` that fetches the icons via sprite from the Drupal backend and
renders it.
