# How to create a new paragraph with blökkli

The blökkli starterkit already comes with a pre-configured set of paragraphs and Vue components.

In this tutorial, we will walk through the steps needed, in order to create a new paragraph / vue component for blökkli.

## 1. Create Paragraph type
Go to `admin/structure/paragraphs_type/add`

![Add your paragraph](/content/images/blokkli_tutorial_1_add_paragraph.png) 

## 2. Enable Paragraph
Make sure, the paragraph type is allowed for the desired content or entity page
Go to `admin/structure/types/manage/page/fields/node.page.field_paragraphs`

![Allow paragraph](/content/images/blokkli_tutorial_2_allow_paragraph.png) 

Note, you can also manage the allowed paragraphs for all entity types.
You can do so at the following blökkli configuration page: `admin/config/content/blokkli/allowed-paragraphs`

## 3. Expose data in GraphQL
As the setup is based on the GraphQL Core Schema module, we want to opt-in for any new data that should be exposed through the GraphQL API.

Go to `admin/config/graphql/servers/manage/graphql`
- expose any newly added Paragraph fields
- expose the new paragraph bundle

![Expose GraphQL](/content/images/blokkli_tutorial_3_expose_graphl.png) 

Also see the following page on further infromation:
https://blokkli-starterkit.netlify.app/drupal/graphql-introduction

## 4. Clear cache

In order to make sure, that the exposed GraphQL data is updated, you need to clear cache.

## 5. Verify data
Let's use the GraphQL Voyager to verify the data structure.
Go to `admin/config/graphql/servers/manage/graphql/explorer`

![GraphQL Voyager](/content/images/blokkli_tutorial_4_voyager.png) 

## 6. Create the vue component

In the frontend, we want a Vue component that corresponds to the paragraph being served from the backend. For this procedure, three steps are needed:

First, we create a GraphQL fragment for the paragraph

![Paragraph Fragment](/content/images/blokkli_tutorial_5_fragment.png) 

Second, we create a Vue component for the paragraph

![Paragraph ](/content/images/blokkli_tutorial_6_template.png)

Third, we register the new Paragraph fragment in the fragment that contains all paragraphs 

![Add template](/content/images/blokkli_tutorial_7_paragraph_fragment.png) 

Check out the existing examples:
https://git.drupalcode.org/project/blokkli_starterkit/-/tree/1.0.x/frontend/components/Paragraph

## 7. Restart the frontend

In order to work with the new paragraph, we need to restart the frontend.

If you started the frontend already, stop it first. Then

```bash
ddev frontend
```

## 8. See your new component in action

Visit the site and see your new component in action

