# nginx Configuration Generator

blökkli starterkit comes with a built-in nginx configuration generator. It automatically creates nginx configuration
files that can be deployed to your server.

## Usage

To generate or update all nginx configuration file, run the following command:

```bash
cd scripts/nginx-conf-generator/
bun install
bun run start
```

## Adapt the routing

Both Drupal and the frontend app are accessible on the same domain.
The incoming requests are automatically routed to the correct app. For
example, `/` is routed to the frontend and `/admin` is routed to Drupal.

If the frontend is not running, the starterkit will automatically fall back to the Drupal backend. Drupal is always
available via /admin.

## How to add Drupal routes in frontend

- Add the routes you would like to be handled by the backend inside `scripts/nginx-conf-generator/config/base.yml`
  file. You can find there a sane default configuration that works for most projects.
- Run `bun install && bun start` inside the `nginx-conf-generator` folder.
- Run `lando reload` or `ddev restart` to restart nginx.


## Configuration

The configuration for your environments including the local environment is stored under
`scripts/nginx-conf-generator/config`.

The configuration is stored in YML format and can be modified to fit your needs.

If you want to create new configuration for your live and staging environments, you can create new files in the
folder `scripts/nginx-conf-generator/config/envs`.

Example `stage.yml`
```yml 
certbot_enabled: true
basic_auth: true
fallback: true
error_page_root: /home/www/develop/frontend/.output/public

sites:
  default:
    server_name: stage.starterkit.com
    frontend_host: localhost
    frontend_port: 3000
    ssl_certificate: /etc/letsencrypt/live/stage.starterkit.com/fullchain.pem
    ssl_certificate_key: /etc/letsencrypt/live/stage.starterkit.com/privkey.pem

php:
  listen: 8888
  fastcgi_pass: 'unix:/var/run/php/php-fpm.sock'
  server_name: localhost
  root: /home/www/develop/drupal/docroot
```

The file will be stored under `deploy/nginx` and can be used to deploy the configuration to your server.
