# GraphQL Core Schema

We love GraphQL and have chosen it as our data fetching mechanism. GraphQL allows us to fetch only the data we need and
nothing more. Using the [Drupal graphql_core_schema modules](https://www.drupal.org/project/graphql_core_schema) 
allows us to start with a configurable auto-generated schema and then extend it with custom fields as needed.

## Why GraphQL over JSON:API?

* GraphQL is awesome for large, complex and interrelated data sources
* No overfetching or underfetching
* Server-side schema
* Strongly typed API architecture and better error handling
* Handles complex queries and mutations with ease

### Comparison GraphQL vs REST

[![rest_fetch.png](/content/images/rest_fetch.png){width=400px}](/content/images/rest_fetch.png){target=_blank}
<small>Source: https://www.howtographql.com/</small>

[![graphql_fetch.png](/content/images/graphql_fetch.png){width=400px}](/content/images/graphql_fetch.png){target=_blank}
<small>Source: https://www.howtographql.com/</small>

## The history of the GraphQL module

* The GraphQL module 3.x shipped with a `graphql_core` module, a ready-to-use schema generator.
* The GraphQL 4.x module does not generate any schema, you have to implement the schema on your own.

Usually, you don't want to create your schema everytime from scratch, when building a new project. That's why we have
created the `graphql_core_schema` module. It's the successor of the `graphql_core` module, but with some important
changes.

## [GraphQL Core Schema Module](https://www.drupal.org/project/graphql_core_schema)

The `graphql_core_schema` module is a configurable schema generator for the Drupal GraphQL 4.x module. 
You can enable entity types and fields in the UI to determine which fields you expose in your schema.

### Opt-in approach

The GraphQL Core Schema allows you to enable only the things you need.

#### Enable entity types and base fields

[![select_overview.png](/content/images/select_overview.png){width=400px}](/content/images/select_overview.png){target=_
blank}
[![select_overview.png](/content/images/types.png){width=500px}](/content/images/types.png){target=_blank}

#### Enable fields

[![fields.png](/content/images/fields.png)](/content/images/fields.png){target=_blank}

### Architecture decisions

* Fully configurable
* Easy extendable
* Following Drupal Core
  * Entity interface for all entities
  * EntityTranslatable interface for all translatable entities
  * FieldItemList interface for each field
  * FieldItemType interface for each field item
* Fully compatible with the GraphQL 4 module

### Setup

The `graphql_core_schema` module is already pre-installed in the starterkit. Head over to the config under
`/admin/config/graphql/servers/manage/graphql` to enable the entity types and fields you need.

You might have to a create small number of access hooks to enable access to certain entity types that don't have a proper default access checks.
The module is secure by default as it only exposes fields that the user has access to as determined by Drupal.

Then you can test your queries in the GraphiQL Explorer under `/admin/config/graphql/servers/manage/graphql/explorer`.

### Documentation

The module comes with a awesome documentation. Check it out in the
[official documentation](https://graphql-core-schema.netlify.app/basics/setup.html).

### Schema Extension

The schema is build with extensions in mind. You can easily extend the schema with custom fields.
The module ships already with a lot of extensions for all common use cases. Here is a small excerpt from the most
important extensions:

* Breadcrumb Extension
* Entity Query Extension
* Image Styles Extension
* Language Switch Links
* Local Tasks Extension
* Masquerade Extension
* Menu Extenson
* Metatag Extension
* Routing Extension
* User / User Login Extension

You can check the submodules in the module folder `graphql_core_schema/modules` for more extensions.
